/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.versioning;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.versioning.DefaultVersioningRuleDescriptor;
import org.nuxeo.ecm.core.versioning.ExtendableVersioningService;
import org.nuxeo.ecm.core.versioning.StandardVersioningService;
import org.nuxeo.ecm.core.versioning.VersioningRuleDescriptor;
import org.nuxeo.ecm.core.versioning.VersioningService;
import org.nuxeo.ecm.core.versioning.VersioningServiceDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class VersioningComponent
extends DefaultComponent
implements VersioningService {
    private static final Log log = LogFactory.getLog(VersioningComponent.class);
    public static final String XP = "versioningService";
    public static final String VERSIONING_RULE_XP = "versioningRules";
    public VersioningService service;
    protected LinkedList<Class<? extends VersioningService>> contribs;
    protected Map<String, VersioningRuleDescriptor> versioningRules;
    protected LinkedList<DefaultVersioningRuleDescriptor> defaultVersioningRuleList;
    protected boolean recompute;

    public void activate(ComponentContext context) {
        this.contribs = new LinkedList();
        this.versioningRules = new HashMap<String, VersioningRuleDescriptor>();
        this.defaultVersioningRuleList = new LinkedList();
        this.recompute = true;
        this.service = null;
    }

    public void deactivate(ComponentContext context) {
        this.contribs.clear();
        this.versioningRules.clear();
        this.defaultVersioningRuleList.clear();
        this.service = null;
    }

    public void registerContribution(Object contrib, String xp, ComponentInstance contributor) {
        if (XP.equals(xp)) {
            Class<?> klass;
            if (!(contrib instanceof VersioningServiceDescriptor)) {
                log.error((Object)("Invalid contribution: " + contrib.getClass().getName()));
                return;
            }
            VersioningServiceDescriptor desc = (VersioningServiceDescriptor)contrib;
            try {
                klass = Class.forName(desc.className);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)("Invalid contribution class: " + desc.className));
                return;
            }
            if (!VersioningService.class.isAssignableFrom(klass)) {
                log.error((Object)("Invalid contribution class: " + desc.className));
                return;
            }
            this.contribs.add(klass);
            log.info((Object)("Registered versioning service: " + desc.className));
            this.recompute = true;
        } else if (VERSIONING_RULE_XP.equals(xp)) {
            if (contrib instanceof VersioningRuleDescriptor) {
                VersioningRuleDescriptor typeSaveOptDescriptor = (VersioningRuleDescriptor)contrib;
                if (typeSaveOptDescriptor.isEnabled()) {
                    this.versioningRules.put(typeSaveOptDescriptor.getTypeName(), typeSaveOptDescriptor);
                } else {
                    this.versioningRules.remove(typeSaveOptDescriptor.getTypeName());
                }
                this.recompute = true;
            } else if (contrib instanceof DefaultVersioningRuleDescriptor) {
                this.defaultVersioningRuleList.add((DefaultVersioningRuleDescriptor)contrib);
                this.recompute = true;
            }
        } else {
            log.error((Object)("Unknown extension point " + xp));
        }
    }

    public void unregisterContribution(Object contrib, String xp, ComponentInstance contributor) {
        if (XP.equals(xp)) {
            Class<VersioningService> klass;
            if (!(contrib instanceof VersioningServiceDescriptor)) {
                return;
            }
            VersioningServiceDescriptor desc = (VersioningServiceDescriptor)contrib;
            try {
                klass = Class.forName(desc.className);
            }
            catch (ClassNotFoundException e) {
                return;
            }
            if (!klass.isAssignableFrom(VersioningService.class)) {
                return;
            }
            this.contribs.remove(klass);
            log.info((Object)("Unregistered versioning service: " + desc.className));
        } else if (VERSIONING_RULE_XP.equals(xp)) {
            if (contrib instanceof VersioningRuleDescriptor) {
                VersioningRuleDescriptor typeSaveOptDescriptor = (VersioningRuleDescriptor)contrib;
                String typeName = typeSaveOptDescriptor.getTypeName();
                if (this.versioningRules.containsKey(typeName)) {
                    this.versioningRules.remove(typeName);
                }
            } else if (contrib instanceof DefaultVersioningRuleDescriptor) {
                this.defaultVersioningRuleList.remove((DefaultVersioningRuleDescriptor)contrib);
            }
            log.info((Object)("Unregistered versioning rule: " + contributor.getName()));
        }
        this.recompute = true;
    }

    protected void recompute() {
        Class klass = this.contribs.size() == 0 ? StandardVersioningService.class : this.contribs.getLast();
        if (this.service == null || klass != this.service.getClass()) {
            try {
                this.service = (VersioningService)klass.newInstance();
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.service != null && this.service instanceof ExtendableVersioningService) {
            ExtendableVersioningService extendableService = (ExtendableVersioningService)this.service;
            extendableService.setVersioningRules(this.versioningRules);
            if (!this.defaultVersioningRuleList.isEmpty()) {
                extendableService.setDefaultVersioningRule(this.defaultVersioningRuleList.getLast());
            }
        }
    }

    public VersioningService getService() {
        if (this.recompute) {
            this.recompute();
            this.recompute = false;
        }
        return this.service;
    }

    @Override
    public String getVersionLabel(DocumentModel doc) {
        return this.getService().getVersionLabel(doc);
    }

    @Override
    public void doPostCreate(Document doc, Map<String, Serializable> options) throws DocumentException {
        this.getService().doPostCreate(doc, options);
    }

    @Override
    public List<VersioningOption> getSaveOptions(DocumentModel docModel) throws ClientException {
        return this.getService().getSaveOptions(docModel);
    }

    @Override
    public boolean isPreSaveDoingCheckOut(Document doc, boolean isDirty, VersioningOption option, Map<String, Serializable> options) throws DocumentException {
        return this.getService().isPreSaveDoingCheckOut(doc, isDirty, option, options);
    }

    @Override
    public VersioningOption doPreSave(Document doc, boolean isDirty, VersioningOption option, String checkinComment, Map<String, Serializable> options) throws DocumentException {
        return this.getService().doPreSave(doc, isDirty, option, checkinComment, options);
    }

    @Override
    public boolean isPostSaveDoingCheckIn(Document doc, VersioningOption option, Map<String, Serializable> options) throws DocumentException {
        return this.getService().isPostSaveDoingCheckIn(doc, option, options);
    }

    @Override
    public Document doPostSave(Document doc, VersioningOption option, String checkinComment, Map<String, Serializable> options) throws DocumentException {
        return this.getService().doPostSave(doc, option, checkinComment, options);
    }

    @Override
    public Document doCheckIn(Document doc, VersioningOption option, String checkinComment) throws DocumentException {
        return this.getService().doCheckIn(doc, option, checkinComment);
    }

    @Override
    public void doCheckOut(Document doc) throws DocumentException {
        this.getService().doCheckOut(doc);
    }
}

