/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.versioning;

import java.io.Serializable;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.facet.VersioningDocument;
import org.nuxeo.ecm.core.versioning.VersioningService;
import org.nuxeo.runtime.api.Framework;

public class VersioningDocumentAdapter
implements VersioningDocument {
    public final DocumentModel doc;
    public final VersioningService service = (VersioningService)Framework.getService(VersioningService.class);

    public VersioningDocumentAdapter(DocumentModel doc) {
        this.doc = doc;
    }

    public Long getMajorVersion() throws DocumentException {
        return this.getValidVersionNumber("uid:major_version");
    }

    public Long getMinorVersion() throws DocumentException {
        return this.getValidVersionNumber("uid:minor_version");
    }

    public String getVersionLabel() {
        return this.service.getVersionLabel(this.doc);
    }

    private long getValidVersionNumber(String propName) {
        Serializable propVal;
        try {
            propVal = this.doc.getPropertyValue(propName);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        return propVal == null || !(propVal instanceof Long) ? 0L : (Long)propVal;
    }
}

