/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.impl.service;

import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.api.RemotePublicationTreeManager;
import org.nuxeo.ecm.platform.publisher.impl.service.AbstractRemotableNode;
import org.nuxeo.runtime.api.Framework;

public class ProxyNode
extends AbstractRemotableNode
implements PublicationNode {
    private static final long serialVersionUID = 1L;
    protected String nodeType;
    protected String nodeLabel;
    protected String nodePath;
    protected String nodeName;

    public ProxyNode(PublicationNode node, String sid) throws ClientException {
        this.nodeType = node.getNodeType();
        this.nodeLabel = node.getTitle();
        this.nodePath = node.getPath();
        this.treeName = node.getTreeConfigName();
        this.nodeName = node.getName();
        this.sessionId = sid;
    }

    @Override
    protected RemotePublicationTreeManager getPublisher() throws ClientException {
        if (this.service == null) {
            this.service = (RemotePublicationTreeManager)Framework.getService(RemotePublicationTreeManager.class);
        }
        return this.service;
    }

    public String getTitle() {
        return this.nodeLabel;
    }

    public String getName() {
        return this.nodeName;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public String getType() {
        return this.getClass().getSimpleName();
    }

    public String getPath() {
        return this.nodePath;
    }

    public String getTreeConfigName() {
        return this.treeName;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    protected String getServerTreeSessionId() {
        return this.getSessionId();
    }

    @Override
    protected String getTargetTreeName() {
        return this.treeName;
    }

    @Override
    protected PublicationNode switchToServerNode(PublicationNode node) throws ClientException {
        return node;
    }

    @Override
    protected PublicationNode switchToClientNode(PublicationNode node) throws ClientException {
        return node;
    }
}

