/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.remoting.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublicationTree;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocumentFactory;
import org.nuxeo.ecm.platform.publisher.api.RemotePublicationTreeManager;
import org.nuxeo.ecm.platform.publisher.impl.service.AbstractRemotableTree;
import org.nuxeo.ecm.platform.publisher.impl.service.ProxyNode;
import org.nuxeo.ecm.platform.publisher.remoting.client.ClientRemotePublicationNode;
import org.nuxeo.ecm.platform.publisher.remoting.marshaling.DefaultMarshaler;
import org.nuxeo.ecm.platform.publisher.remoting.marshaling.basic.BasicPublicationNode;
import org.nuxeo.ecm.platform.publisher.remoting.marshaling.interfaces.RemotePublisherMarshaler;
import org.nuxeo.ecm.platform.publisher.remoting.restProxies.RemotePublicationTreeManagerRestProxy;
import org.nuxeo.runtime.api.Framework;

public class ClientRemotePublicationTree
extends AbstractRemotableTree
implements PublicationTree {
    private static final long serialVersionUID = 1L;
    protected static final String ORGSERVER_KEY = "originalServer";
    protected static final String USERNAME_KEY = "userName";
    protected static final String PASSWORD_KEY = "password";
    protected static final String BASEURL_KEY = "baseURL";
    protected static final String MARSHALER_KEY = "marshaler";
    protected static final String TARGETTREENAME_KEY = "targetTree";
    public static final String ICON_EXPANDED_KEY = "iconExpanded";
    public static final String ICON_COLLAPSED_KEY = "iconCollapsed";
    public static final String TITLE_KEY = "title";
    protected String targetTreeName;
    protected String name;
    protected String serverSessionId;
    protected String title;
    protected String treeTitle;
    protected String rootPath;
    protected String nodeType;
    protected String iconCollapsed = "/icons/folder.gif";
    protected String iconExpanded = "/icons/folder_open.gif";
    protected PublishedDocumentFactory factory;
    protected ClientRemotePublicationNode rootNode;
    protected CoreSession coreSession;

    @Override
    protected String getTargetTreeName() {
        return this.targetTreeName;
    }

    @Override
    protected PublicationNode switchToClientNode(PublicationNode node) throws ClientException {
        return new ClientRemotePublicationNode(this.configName, this.sessionId, node, this.serverSessionId, this.treeService, this.getTargetTreeName());
    }

    @Override
    protected PublicationNode switchToServerNode(PublicationNode node) {
        if (node instanceof ClientRemotePublicationNode) {
            ClientRemotePublicationNode cNode = (ClientRemotePublicationNode)node;
            return new BasicPublicationNode(cNode.getNodeType(), cNode.getPath(), cNode.getTitle(), cNode.getUnwrappedTreeName(), this.serverSessionId);
        }
        if (node instanceof ProxyNode) {
            ProxyNode rNode = (ProxyNode)node;
            return new BasicPublicationNode(rNode.getNodeType(), rNode.getPath(), rNode.getTitle(), this.getTargetTreeName(), this.serverSessionId);
        }
        return node;
    }

    public void initTree(String sid, CoreSession coreSession, Map<String, String> parameters, PublishedDocumentFactory factory, String configName, String title) throws ClientException {
        DefaultMarshaler marshaler;
        this.sessionId = sid;
        this.name = "Remote";
        this.configName = configName;
        this.factory = factory;
        this.coreSession = coreSession;
        this.treeTitle = title != null ? title : configName;
        String userName = parameters.get(USERNAME_KEY);
        String password = parameters.get(PASSWORD_KEY);
        String baseURL = Framework.expandVars((String)parameters.get(BASEURL_KEY));
        String marshalerClassName = parameters.get(MARSHALER_KEY);
        this.targetTreeName = parameters.get(TARGETTREENAME_KEY);
        if (this.targetTreeName == null) {
            this.targetTreeName = this.name;
        }
        if (parameters.containsKey(ICON_COLLAPSED_KEY)) {
            this.iconCollapsed = parameters.get(ICON_COLLAPSED_KEY);
        }
        if (parameters.containsKey(ICON_EXPANDED_KEY)) {
            this.iconExpanded = parameters.get(ICON_EXPANDED_KEY);
        }
        if (marshalerClassName == null) {
            marshaler = new DefaultMarshaler();
        } else {
            try {
                marshaler = (RemotePublisherMarshaler)Class.forName(marshalerClassName).newInstance();
            }
            catch (ReflectiveOperationException e) {
                marshaler = new DefaultMarshaler();
            }
        }
        marshaler.setAssociatedCoreSession(coreSession);
        marshaler.setParameters(parameters);
        this.treeService = new RemotePublicationTreeManagerRestProxy(baseURL, userName, password, marshaler);
        HashMap remoteParameters = new HashMap();
        Map rTree = this.treeService.initRemoteSession(this.targetTreeName, remoteParameters);
        this.serverSessionId = (String)rTree.get("sessionId");
        this.title = (String)rTree.get(TITLE_KEY);
        this.rootPath = (String)rTree.get("path");
        this.nodeType = (String)rTree.get("nodeType");
        BasicPublicationNode basicRootNode = new BasicPublicationNode(this.nodeType, this.rootPath, this.title, configName, this.sessionId);
        this.rootNode = new ClientRemotePublicationNode(configName, this.sessionId, basicRootNode, this.serverSessionId, this.treeService, this.getTargetTreeName());
    }

    @Override
    protected RemotePublicationTreeManager getTreeService() throws ClientException {
        return this.treeService;
    }

    public List<PublishedDocument> getChildrenDocuments() throws ClientException {
        return this.rootNode.getChildrenDocuments();
    }

    public String getPath() {
        return this.rootPath;
    }

    public String getTitle() {
        return this.title;
    }

    public String getTreeTitle() {
        return this.treeTitle;
    }

    public String getName() {
        return this.name;
    }

    public String getTreeType() {
        return "RemoteTree";
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public String getTreeConfigName() {
        return this.configName;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getRemoteSessionId() {
        return this.getServerTreeSessionId();
    }

    @Override
    protected String getServerTreeSessionId() {
        return this.serverSessionId;
    }

    @Override
    public PublishedDocument publish(DocumentModel doc, PublicationNode targetNode, Map<String, String> params) throws ClientException {
        doc = this.factory.snapshotDocumentBeforePublish(doc);
        return super.publish(doc, targetNode, params);
    }

    public List<PublicationNode> getChildrenNodes() throws ClientException {
        return this.rootNode.getChildrenNodes();
    }

    public String getType() {
        return this.getClass().getSimpleName();
    }

    @Override
    public List<PublishedDocument> getExistingPublishedDocument(DocumentLocation docLoc) throws ClientException {
        ArrayList<PublishedDocument> allPubDocs = new ArrayList<PublishedDocument>();
        List<Object> possibleDocsToCheck = new ArrayList<DocumentModel>();
        DocumentModel livedoc = this.coreSession.getDocument(docLoc.getDocRef());
        if (!livedoc.isVersion()) {
            possibleDocsToCheck = this.coreSession.getVersions(docLoc.getDocRef());
        }
        possibleDocsToCheck.add(0, livedoc);
        for (DocumentModel doc : possibleDocsToCheck) {
            List pubDocs = this.getTreeService().getExistingPublishedDocument(this.getServerTreeSessionId(), (DocumentLocation)new DocumentLocationImpl(doc));
            allPubDocs.addAll(pubDocs);
        }
        return allPubDocs;
    }

    public String getIconExpanded() {
        return this.iconExpanded;
    }

    public String getIconCollapsed() {
        return this.iconCollapsed;
    }
}

