/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.platform.audit.api.AuditLogger;
import org.nuxeo.ecm.platform.audit.api.AuditRuntimeException;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.runtime.api.Framework;

public class IOLogEntryBase {
    private static final Log log = LogFactory.getLog(IOLogEntryBase.class);
    public static final String DOCUMENT_TAG = "documentLogs";
    public static final String LOGENTRY_TAG = "logEntry";

    public static void write(List<LogEntry> logEntries, OutputStream out) throws IOException {
        Document jdoc = IOLogEntryBase.writeDocument(logEntries);
        IOLogEntryBase.writeXML(jdoc, out);
    }

    private static Document writeDocument(List<LogEntry> logEntries) {
        Document document = DocumentFactory.getInstance().createDocument();
        document.setName("logEntries");
        Element rootElement = document.addElement(DOCUMENT_TAG);
        for (LogEntry logEntry : logEntries) {
            Element logEntryElement = rootElement.addElement(LOGENTRY_TAG);
            IOLogEntryBase.writeLogEntry(logEntryElement, logEntry);
        }
        return document;
    }

    protected static void writeLogEntry(Element logEntryElement, LogEntry logEntry) {
        logEntryElement.addAttribute("category", logEntry.getCategory());
        logEntryElement.addAttribute("comment", logEntry.getComment());
        logEntryElement.addAttribute("docLifeCycle", logEntry.getDocLifeCycle());
        logEntryElement.addAttribute("docPath", logEntry.getDocPath());
        logEntryElement.addAttribute("docType", logEntry.getDocType());
        logEntryElement.addAttribute("docUUID", logEntry.getDocUUID());
        logEntryElement.addAttribute("repoId", logEntry.getRepositoryId());
        String creationDate = IOLogEntryBase.getDateFormat().format(logEntry.getEventDate());
        logEntryElement.addAttribute("creationDate", creationDate);
        logEntryElement.addAttribute("eventId", logEntry.getEventId());
        logEntryElement.addAttribute("principalName", logEntry.getPrincipalName());
    }

    public static List<LogEntry> read(InputStream in) throws IOException {
        Document jDoc = IOLogEntryBase.loadXML(in);
        return IOLogEntryBase.readDocument(jDoc);
    }

    protected static List<LogEntry> readDocument(Document doc) {
        ArrayList<LogEntry> logEntries = new ArrayList<LogEntry>();
        AuditLogger audit = (AuditLogger)Framework.getLocalService(AuditLogger.class);
        Element rootElement = doc.getRootElement();
        Iterator it = rootElement.elementIterator();
        while (it.hasNext()) {
            Element logEntryElement = (Element)it.next();
            LogEntry logEntry = IOLogEntryBase.readLogEntry(audit, logEntryElement);
            logEntries.add(logEntry);
        }
        return logEntries;
    }

    protected static LogEntry readLogEntry(AuditLogger audit, Element logEntryElement) {
        LogEntry logEntry = audit.newLogEntry();
        logEntry.setCategory(logEntryElement.attributeValue("category"));
        logEntry.setComment(logEntryElement.attributeValue("comment"));
        logEntry.setDocLifeCycle(logEntryElement.attributeValue("docLifeCycle"));
        logEntry.setDocPath(logEntryElement.attributeValue("docPath"));
        logEntry.setDocType(logEntryElement.attributeValue("docType"));
        logEntry.setDocUUID(logEntryElement.attributeValue("docUUID"));
        logEntry.setRepositoryId(logEntryElement.attributeValue("repoId"));
        try {
            Date creationDate = IOLogEntryBase.getDateFormat().parse(logEntryElement.attributeValue("creationDate"));
            logEntry.setEventDate(creationDate);
        }
        catch (ParseException e) {
            log.error((Object)e, (Throwable)e);
        }
        logEntry.setEventId(logEntryElement.attributeValue("eventId"));
        logEntry.setPrincipalName(logEntryElement.attributeValue("principalName"));
        return logEntry;
    }

    protected static DateFormat getDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    protected static void writeXML(Document doc, OutputStream out) throws IOException {
        OutputFormat format = OutputFormat.createPrettyPrint();
        XMLWriter writer = new XMLWriter(out, format);
        writer.write(doc);
    }

    private static Document loadXML(InputStream in) throws IOException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            FileUtils.copy((InputStream)in, (OutputStream)baos);
            return new SAXReader().read((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        }
        catch (DocumentException e) {
            IOException ioe = new IOException("Failed to read log entry : " + e.getMessage());
            ioe.setStackTrace(e.getStackTrace());
            throw ioe;
        }
    }

    public static List<LogEntry> translate(List<LogEntry> docLogs, DocumentRef newRef) {
        ArrayList<LogEntry> newList = new ArrayList<LogEntry>();
        for (LogEntry logEntry : docLogs) {
            LogEntry newLogEntry = IOLogEntryBase.translate(logEntry, newRef);
            newList.add(newLogEntry);
        }
        return newList;
    }

    private static LogEntry translate(LogEntry logEntry, DocumentRef newRef) {
        LogEntry newLogEntry;
        try {
            newLogEntry = (LogEntry)BeanUtils.cloneBean((Object)logEntry);
        }
        catch (ReflectiveOperationException e) {
            throw new AuditRuntimeException("cannot clone bean " + logEntry, (Throwable)e);
        }
        newLogEntry.setDocUUID(newRef);
        return newLogEntry;
    }
}

