/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.download;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.storage.StorageBlob;
import org.nuxeo.ecm.platform.web.common.ServletHelper;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.ExceptionHelper;
import org.nuxeo.ecm.platform.web.common.requestcontroller.filter.BufferingServletOutputStream;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;

public class DownloadServlet
extends HttpServlet {
    protected static final String NXDOWNLOADINFO_PREFIX = "nxdownloadinfo";
    protected static final String NXBIGFILE_PREFIX = "nxbigfile";
    protected static final String NXBIGBLOB_PREFIX = "nxbigblob";
    protected static final int BUFFER_SIZE = 524288;
    protected static final int MIN_BUFFER_SIZE = 65536;
    protected static final Blob BLOB_NOT_FOUND = new StringBlob("404");
    private static final long serialVersionUID = 986876871L;
    private static final Log log = LogFactory.getLog(DownloadServlet.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String requestURI;
        try {
            requestURI = new URI(req.getRequestURI()).getPath();
        }
        catch (URISyntaxException e1) {
            requestURI = req.getRequestURI();
        }
        if (requestURI.contains("/nxbigfile/")) {
            this.handleDownloadSingleDocument(req, resp, requestURI);
        } else if (requestURI.contains("/nxdownloadinfo/")) {
            this.handleGetDownloadInfo(req, resp, requestURI);
        } else if (requestURI.contains("/nxbigzipfile/")) {
            this.handleDownloadTemporaryZip(req, resp, requestURI);
        } else if (requestURI.contains("/nxbigblob/")) {
            this.handleDownloadSingleBlob(req, resp, requestURI);
        }
    }

    /*
     * Exception decompiling
     */
    protected Blob resolveBlob(HttpServletRequest req, HttpServletResponse resp, String requestURI) throws ServletException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void handleGetDownloadInfo(HttpServletRequest req, HttpServletResponse resp, String requestURI) throws ServletException {
        String downloadUrl = requestURI.replace(NXDOWNLOADINFO_PREFIX, NXBIGFILE_PREFIX);
        Blob blob = this.resolveBlob(req, resp, downloadUrl);
        if (!this.isBlobFound(blob, resp)) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        resp.setContentType("text/plain");
        try {
            sb.append(blob.getMimeType());
            sb.append(":");
            sb.append(URLEncoder.encode(blob.getFilename(), "UTF-8"));
            sb.append(":");
            sb.append(VirtualHostHelper.getServerURL((ServletRequest)req));
            sb.append(downloadUrl.substring(1));
            resp.getWriter().write(sb.toString());
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private boolean isBlobFound(Blob blob, HttpServletResponse resp) throws ServletException {
        if (blob == null) {
            try {
                resp.sendError(204, "No Blob found");
                return false;
            }
            catch (IOException e) {
                throw new ServletException((Throwable)e);
            }
        }
        if (BLOB_NOT_FOUND.equals(blob)) {
            try {
                resp.sendError(404, "No Blob found");
                return false;
            }
            catch (IOException e) {
                throw new ServletException((Throwable)e);
            }
        }
        return true;
    }

    protected void handleDownloadSingleDocument(HttpServletRequest req, HttpServletResponse resp, String requestURI) throws ServletException {
        Blob blob = this.resolveBlob(req, resp, requestURI);
        if (!this.isBlobFound(blob, resp)) {
            return;
        }
        try {
            this.downloadBlob(req, resp, blob, null);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void handleDownloadSingleBlob(HttpServletRequest req, HttpServletResponse resp, String requestURI) throws ServletException {
        String blobId = requestURI.replace(VirtualHostHelper.getContextPath((ServletRequest)req) + "/" + NXBIGBLOB_PREFIX + "/", "");
        HttpSession session = req.getSession(false);
        if (session == null) {
            log.error((Object)"Unable to download blob since the holding http session does not exist");
            return;
        }
        Blob blob = (Blob)session.getAttribute(blobId);
        if (blob != null) {
            session.removeAttribute(blobId);
            try {
                this.downloadBlob(req, resp, blob, null);
            }
            catch (IOException e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadBlob(HttpServletRequest req, HttpServletResponse resp, Blob blob, String fileName) throws IOException, ServletException {
        block23: {
            InputStream in = blob.getStream();
            ServletOutputStream out = resp.getOutputStream();
            try {
                String previousToken;
                String digest = null;
                if (blob instanceof StorageBlob) {
                    digest = ((StorageBlob)blob).getBinary().getDigest();
                }
                if ((previousToken = req.getHeader("If-None-Match")) != null && previousToken.equals(digest)) {
                    resp.sendError(304);
                    break block23;
                }
                resp.setHeader("ETag", digest);
                if (fileName == null || fileName.length() == 0) {
                    fileName = blob.getFilename() != null && blob.getFilename().length() > 0 ? blob.getFilename() : "file";
                }
                resp.setHeader("Content-Disposition", ServletHelper.getRFC2231ContentDisposition(req, fileName));
                resp.setContentType(blob.getMimeType());
                long fileSize = blob.getLength();
                if (fileSize <= 0L) break block23;
                String range = req.getHeader("Range");
                ByteRange byteRange = null;
                if (range != null) {
                    try {
                        byteRange = DownloadServlet.parseRange(range, fileSize);
                    }
                    catch (ClientException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                if (byteRange != null) {
                    resp.setHeader("Accept-Ranges", "bytes");
                    resp.setHeader("Content-Range", "bytes " + byteRange.getStart() + "-" + byteRange.getEnd() + "/" + fileSize);
                    long length = byteRange.getLength();
                    if (length < Integer.MAX_VALUE) {
                        resp.setContentLength((int)length);
                    }
                    resp.setStatus(206);
                    DownloadServlet.writeStream(in, (OutputStream)out, byteRange);
                } else {
                    if (fileSize < Integer.MAX_VALUE) {
                        resp.setContentLength((int)fileSize);
                    }
                    DownloadServlet.writeStream(in, (OutputStream)out, new ByteRange(0L, fileSize - 1L));
                }
            }
            catch (IOException ioe) {
                this.handleClientDisconnect(ioe);
            }
            finally {
                if (resp != null) {
                    try {
                        resp.flushBuffer();
                    }
                    catch (IOException ioe) {
                        this.handleClientDisconnect(ioe);
                    }
                }
                if (in != null) {
                    in.close();
                }
            }
        }
    }

    public void handleClientDisconnect(IOException ioe) throws IOException {
        if (!ExceptionHelper.isClientAbortError(ioe)) {
            throw ioe;
        }
        log.debug((Object)("Client disconnected: " + ioe.getMessage()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDownloadTemporaryZip(HttpServletRequest req, HttpServletResponse resp, String requestURI) throws IOException, ServletException {
        String filePath = requestURI.replace(VirtualHostHelper.getContextPath((ServletRequest)req) + "/nxbigzipfile/", "");
        String[] pathParts = filePath.split("/");
        String tmpFileName = pathParts[0];
        File tmpZip = new File(System.getProperty("java.io.tmpdir") + "/" + tmpFileName);
        try {
            FileBlob zipBlob = new FileBlob(tmpZip);
            this.downloadBlob(req, resp, (Blob)zipBlob, "clipboard.zip");
        }
        finally {
            tmpZip.delete();
        }
    }

    public static void writeStream(InputStream in, OutputStream out, ByteRange range) throws IOException {
        long read;
        long offset;
        BufferingServletOutputStream.stopBuffering(out);
        byte[] buffer = new byte[524288];
        in.skip(offset);
        for (offset = range.getStart(); offset <= range.getEnd() && (read = (long)in.read(buffer)) != -1L; offset += read) {
            read = Math.min(read, range.getEnd() - offset + 1L);
            out.write(buffer, 0, (int)read);
            out.flush();
        }
    }

    public static ByteRange parseRange(String range, long fileSize) throws ClientException {
        if (!range.startsWith("bytes=") || range.indexOf(44) >= 0) {
            throw new ClientException("Cannot parse range : " + range);
        }
        int sepIndex = range.indexOf(45, 6);
        if (sepIndex < 0) {
            throw new ClientException("Cannot parse range : " + range);
        }
        String start = range.substring(6, sepIndex).trim();
        String end = range.substring(sepIndex + 1).trim();
        long rangeStart = 0L;
        long rangeEnd = fileSize - 1L;
        if (start.isEmpty()) {
            if (end.isEmpty()) {
                throw new ClientException("Cannot parse range : " + range);
            }
            rangeStart = fileSize - (long)Integer.parseInt(end);
            if (rangeStart < 0L) {
                rangeStart = 0L;
            }
        } else {
            rangeStart = Integer.parseInt(start);
            if (!end.isEmpty()) {
                rangeEnd = Integer.parseInt(end);
            }
        }
        if (rangeStart > rangeEnd) {
            throw new ClientException("Cannot parse range : " + range);
        }
        return new ByteRange(rangeStart, rangeEnd);
    }

    public static class ByteRange {
        private long start;
        private long end;

        public ByteRange(long rangeStart, long rangeEnd) {
            this.start = rangeStart;
            this.end = rangeEnd;
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }

        public long getLength() {
            return this.end - this.start + 1L;
        }
    }
}

