/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.requestcontroller.filter;

import java.io.IOException;
import java.security.Principal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.web.common.ServletHelper;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.ExceptionHelper;
import org.nuxeo.ecm.platform.web.common.requestcontroller.filter.BufferingHttpServletResponse;
import org.nuxeo.ecm.platform.web.common.requestcontroller.filter.RemoteHostGuessExtractor;
import org.nuxeo.ecm.platform.web.common.requestcontroller.service.RequestControllerManager;
import org.nuxeo.ecm.platform.web.common.requestcontroller.service.RequestFilterConfig;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class NuxeoRequestControllerFilter
implements Filter {
    protected static final String SESSION_LOCK_KEY = "NuxeoSessionLockKey";
    protected static final String SYNCED_REQUEST_FLAG = "NuxeoSessionAlreadySync";
    protected static final int LOCK_TIMOUT_S = 120;
    public static final DateFormat HTTP_EXPIRES_DATE_FORMAT = NuxeoRequestControllerFilter.httpExpiresDateFormat();
    protected static RequestControllerManager rcm;
    private static final Log log;

    public void init(FilterConfig filterConfig) throws ServletException {
        NuxeoRequestControllerFilter.doInitIfNeeded();
    }

    private static void doInitIfNeeded() {
        if (rcm == null) {
            if (Framework.getRuntime() != null) {
                rcm = (RequestControllerManager)Framework.getLocalService(RequestControllerManager.class);
                if (rcm == null) {
                    log.error((Object)"Unable to get RequestControllerManager service");
                }
                log.debug((Object)"Staring NuxeoRequestController filter");
            } else {
                log.debug((Object)"Postpone filter init since Runtime is not yet available");
            }
        }
    }

    public static String doFormatLogMessage(HttpServletRequest request, String info) {
        String remoteHost = RemoteHostGuessExtractor.getRemoteHost(request);
        Principal principal = request.getUserPrincipal();
        String principalName = principal != null ? principal.getName() : "none";
        String uri = request.getRequestURI();
        HttpSession session = request.getSession(false);
        String sessionId = session != null ? session.getId() : "none";
        String threadName = Thread.currentThread().getName();
        return "remote=" + remoteHost + ",principal=" + principalName + ",uri=" + uri + ",session=" + sessionId + ",thread=" + threadName + ",info=" + info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block29: {
            boolean isCached;
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            if (log.isDebugEnabled()) {
                log.debug((Object)NuxeoRequestControllerFilter.doFormatLogMessage(httpRequest, "Entering NuxeoRequestController filter"));
            }
            NuxeoRequestControllerFilter.doInitIfNeeded();
            RequestFilterConfig config = rcm.getConfigForRequest(httpRequest);
            boolean useSync = config.needSynchronization();
            boolean useTx = config.needTransaction();
            if (httpRequest.getMethod().equals("GET") && (isCached = config.isCached())) {
                NuxeoRequestControllerFilter.addCacheHeader(httpResponse, config.isPrivate(), config.getCacheTime());
            }
            if (!useSync && !useTx) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)NuxeoRequestControllerFilter.doFormatLogMessage(httpRequest, "Existing NuxeoRequestController filter: nothing to be done"));
                }
                try {
                    chain.doFilter(request, response);
                }
                catch (ServletException e) {
                    Throwable unwrappedError = ExceptionHelper.unwrapException(e);
                    if (ExceptionHelper.isClientAbortError(unwrappedError)) {
                        log.warn((Object)("Client disconnected: " + unwrappedError.getMessage()));
                    }
                    throw e;
                }
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)NuxeoRequestControllerFilter.doFormatLogMessage(httpRequest, "Handling request with tx=" + useTx + " and sync=" + useSync));
            }
            boolean sessionSynched = false;
            if (useSync) {
                sessionSynched = NuxeoRequestControllerFilter.simpleSyncOnSession(httpRequest);
            }
            boolean txStarted = false;
            try {
                if (useTx && (txStarted = ServletHelper.startTransaction(httpRequest)) && config.needTransactionBuffered()) {
                    response = new BufferingHttpServletResponse(httpResponse);
                }
                chain.doFilter(request, response);
            }
            catch (Exception e) {
                Throwable unwrappedError;
                if (txStarted) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)NuxeoRequestControllerFilter.doFormatLogMessage(httpRequest, "Marking transaction for RollBack"));
                    }
                    TransactionHelper.setTransactionRollbackOnly();
                }
                if (ExceptionHelper.isClientAbortError(unwrappedError = ExceptionHelper.unwrapException(e))) {
                    log.warn((Object)("Client disconnected: " + unwrappedError.getMessage()));
                    break block29;
                }
                log.error((Object)NuxeoRequestControllerFilter.doFormatLogMessage(httpRequest, "Unhandled error was caught by the Filter"), (Throwable)e);
                throw new ServletException((Throwable)e);
            }
            finally {
                if (txStarted) {
                    try {
                        TransactionHelper.commitOrRollbackTransaction();
                    }
                    finally {
                        if (config.needTransactionBuffered()) {
                            ((BufferingHttpServletResponse)((Object)response)).stopBuffering();
                        }
                    }
                }
                if (sessionSynched) {
                    NuxeoRequestControllerFilter.simpleReleaseSyncOnSession(httpRequest);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)NuxeoRequestControllerFilter.doFormatLogMessage(httpRequest, "Exiting NuxeoRequestController filter"));
                }
            }
        }
    }

    public static boolean simpleSyncOnSession(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)NuxeoRequestControllerFilter.doFormatLogMessage(request, "HttpSession does not exist, this request won't be synched"));
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)NuxeoRequestControllerFilter.doFormatLogMessage(request, "Trying to sync on session "));
        }
        if (request.getAttribute(SYNCED_REQUEST_FLAG) != null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)NuxeoRequestControllerFilter.doFormatLogMessage(request, "Request has already be synced, filter is reentrant, exiting without locking"));
            }
            return false;
        }
        Lock lock = (Lock)session.getAttribute(SESSION_LOCK_KEY);
        if (lock == null) {
            lock = new ReentrantLock();
            session.setAttribute(SESSION_LOCK_KEY, (Object)lock);
        }
        boolean locked = false;
        try {
            locked = lock.tryLock(120L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error((Object)NuxeoRequestControllerFilter.doFormatLogMessage(request, "Unable to acquire lock for Session sync"), (Throwable)e);
            return false;
        }
        if (locked) {
            request.setAttribute(SYNCED_REQUEST_FLAG, (Object)true);
            if (log.isDebugEnabled()) {
                log.debug((Object)NuxeoRequestControllerFilter.doFormatLogMessage(request, "Request synced on session"));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)NuxeoRequestControllerFilter.doFormatLogMessage(request, "Sync timeout"));
        }
        return locked;
    }

    public static boolean simpleReleaseSyncOnSession(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)NuxeoRequestControllerFilter.doFormatLogMessage(request, "No more HttpSession: can not unlock !, HttpSession must have been invalidated"));
            }
            return false;
        }
        log.debug((Object)("Trying to unlock on session " + session.getId() + " on Thread " + Thread.currentThread().getId()));
        Lock lock = (Lock)session.getAttribute(SESSION_LOCK_KEY);
        if (lock == null) {
            log.error((Object)"Unable to find session lock, HttpSession may have been invalidated");
            return false;
        }
        lock.unlock();
        if (request.getAttribute(SYNCED_REQUEST_FLAG) != null) {
            request.removeAttribute(SYNCED_REQUEST_FLAG);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"session unlocked on Thread ");
        }
        return true;
    }

    private static DateFormat httpExpiresDateFormat() {
        SimpleDateFormat df = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df;
    }

    public static void addCacheHeader(HttpServletResponse httpResponse, Boolean isPrivate, String cacheTime) {
        if (isPrivate.booleanValue()) {
            httpResponse.addHeader("Cache-Control", "private, max-age=" + cacheTime);
        } else {
            httpResponse.addHeader("Cache-Control", "public, max-age=" + cacheTime);
        }
        Date date = new Date();
        long newDate = date.getTime() + new Long(cacheTime) * 1000L;
        date.setTime(newDate);
        httpResponse.setHeader("Expires", HTTP_EXPIRES_DATE_FORMAT.format(date));
    }

    public void destroy() {
        rcm = null;
    }

    static {
        log = LogFactory.getLog(NuxeoRequestControllerFilter.class);
    }
}

