/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.elements;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.elements.Element;
import org.nuxeo.theme.elements.ElementType;
import org.nuxeo.theme.types.TypeFamily;
import org.nuxeo.theme.uids.UidManager;

public final class ElementFactory {
    private static final Log log = LogFactory.getLog(ElementFactory.class);

    private ElementFactory() {
    }

    public static Element create(String typeName) {
        ElementType elementType = (ElementType)Manager.getTypeRegistry().lookup(TypeFamily.ELEMENT, typeName);
        String className = elementType.getClassName();
        UidManager uidManager = Manager.getUidManager();
        if (className == null) {
            return null;
        }
        Element element = null;
        try {
            element = (Element)Class.forName(className).newInstance();
            element.setElementType(elementType);
            uidManager.register(element);
        }
        catch (ReflectiveOperationException e) {
            log.error((Object)"Could not create element", (Throwable)e);
        }
        return element;
    }
}

