/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.fragments;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.elements.ElementType;
import org.nuxeo.theme.fragments.Fragment;
import org.nuxeo.theme.fragments.FragmentType;
import org.nuxeo.theme.types.TypeFamily;
import org.nuxeo.theme.types.TypeRegistry;
import org.nuxeo.theme.uids.UidManager;

public final class FragmentFactory {
    private static final Log log = LogFactory.getLog(FragmentFactory.class);

    public static Fragment create(String typeName) {
        TypeRegistry typeRegistry = Manager.getTypeRegistry();
        ElementType elementType = (ElementType)typeRegistry.lookup(TypeFamily.ELEMENT, "fragment");
        FragmentType fragmentType = (FragmentType)typeRegistry.lookup(TypeFamily.FRAGMENT, typeName);
        if (fragmentType == null) {
            log.error((Object)("Fragment type not found: " + typeName));
            return null;
        }
        String className = fragmentType.getClassName();
        UidManager uidManager = Manager.getUidManager();
        Fragment fragment = null;
        try {
            fragment = (Fragment)Class.forName(className).newInstance();
            fragment.setElementType(elementType);
            fragment.setFragmentType(fragmentType);
            uidManager.register(fragment);
        }
        catch (ReflectiveOperationException e) {
            log.error((Object)e, (Throwable)e);
        }
        return fragment;
    }
}

