/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.negotiation;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.theme.negotiation.Scheme;
import org.nuxeo.theme.types.Type;
import org.nuxeo.theme.types.TypeFamily;

@XObject(value="negotiation")
public final class NegotiationType
implements Type {
    private static final Log log = LogFactory.getLog(NegotiationType.class);
    @XNode(value="@object")
    public String object;
    @XNode(value="@strategy")
    public String strategy;
    @XNodeList(value="scheme", type=ArrayList.class, componentType=String.class)
    private List<String> schemeClassNames;
    private List<Scheme> schemes;

    @Override
    public String getTypeName() {
        return String.format("%s/%s", this.strategy, this.object);
    }

    @Override
    public TypeFamily getTypeFamily() {
        return TypeFamily.NEGOTIATION;
    }

    public synchronized List<Scheme> getSchemes() {
        if (this.schemes == null && this.schemeClassNames != null) {
            this.schemes = new ArrayList<Scheme>();
            for (String schemeClassName : this.schemeClassNames) {
                Scheme scheme = null;
                try {
                    scheme = (Scheme)Class.forName(schemeClassName).newInstance();
                }
                catch (ReflectiveOperationException e) {
                    log.error((Object)("Could not create instance: " + schemeClassName));
                    continue;
                }
                this.schemes.add(scheme);
            }
        }
        return this.schemes;
    }

    public String getStrategy() {
        return this.strategy;
    }

    public String getObject() {
        return this.object;
    }
}

