/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.preview.adapter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.platform.preview.adapter.AdapterFactoryDescriptor;
import org.nuxeo.ecm.platform.preview.adapter.BlobPostProcessor;
import org.nuxeo.ecm.platform.preview.adapter.BlobPostProcessorDescriptor;
import org.nuxeo.ecm.platform.preview.adapter.MimeTypePreviewer;
import org.nuxeo.ecm.platform.preview.adapter.MimeTypePreviewerDescriptor;
import org.nuxeo.ecm.platform.preview.adapter.PreviewAdapterFactory;
import org.nuxeo.ecm.platform.preview.adapter.PreviewAdapterManager;
import org.nuxeo.ecm.platform.preview.adapter.factories.BlobHolderPreviewAdapterFactory;
import org.nuxeo.ecm.platform.preview.adapter.factories.FileBasedPreviewAdapterFactory;
import org.nuxeo.ecm.platform.preview.api.HtmlPreviewAdapter;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class PreviewAdapterManagerComponent
extends DefaultComponent
implements PreviewAdapterManager {
    public static final String ADAPTER_FACTORY_EP = "AdapterFactory";
    public static final String PREVIEWED_MIME_TYPE = "MimeTypePreviewer";
    public static final String BLOB_POST_PROCESSOR_EP = "blobPostProcessor";
    private static final Log log = LogFactory.getLog(PreviewAdapterManagerComponent.class);
    protected Map<String, PreviewAdapterFactory> factoryRegistry = new HashMap<String, PreviewAdapterFactory>();
    protected Map<String, MimeTypePreviewer> previewerFactory = new HashMap<String, MimeTypePreviewer>();
    protected List<BlobPostProcessor> blobPostProcessors = new ArrayList<BlobPostProcessor>();

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (ADAPTER_FACTORY_EP.equals(extensionPoint)) {
            AdapterFactoryDescriptor desc = (AdapterFactoryDescriptor)contribution;
            if (desc.isEnabled()) {
                PreviewAdapterFactory factory = desc.getNewInstance();
                if (factory != null) {
                    this.factoryRegistry.put(desc.getTypeName(), factory);
                }
            } else {
                this.factoryRegistry.remove(desc.getTypeName());
            }
        } else if (PREVIEWED_MIME_TYPE.equals(extensionPoint)) {
            MimeTypePreviewerDescriptor desc = (MimeTypePreviewerDescriptor)contribution;
            this.previewerFactory.put(desc.getPattern(), this.newInstance(desc.getKlass()));
        } else if (BLOB_POST_PROCESSOR_EP.equals(extensionPoint)) {
            BlobPostProcessorDescriptor desc = (BlobPostProcessorDescriptor)contribution;
            this.blobPostProcessors.add(this.newInstance(desc.getKlass()));
        }
    }

    protected <T> T newInstance(Class<T> klass) {
        try {
            return klass.newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
    }

    @Override
    public boolean hasAdapter(DocumentModel doc) {
        if (doc == null) {
            return false;
        }
        String docType = doc.getType();
        if (this.factoryRegistry.containsKey(docType)) {
            return true;
        }
        return doc.hasSchema("file") || doc.hasSchema("files");
    }

    @Override
    public HtmlPreviewAdapter getAdapter(DocumentModel doc) {
        if (doc == null) {
            return null;
        }
        String docType = doc.getType();
        log.debug((Object)("Looking for HTMLPreviewAdapter for type " + docType));
        if (this.factoryRegistry.containsKey(docType)) {
            log.debug((Object)"dedicated HTMLPreviewAdapter factory found");
            return this.factoryRegistry.get(docType).getAdapter(doc);
        }
        if (doc.isFolder()) {
            return null;
        }
        BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
        if (bh != null) {
            log.debug((Object)"using Blob Holder based HtmlPreviewAdapter factory");
            BlobHolderPreviewAdapterFactory factory = new BlobHolderPreviewAdapterFactory();
            return factory.getAdapter(doc);
        }
        if (doc.hasSchema("file") || doc.hasSchema("files")) {
            log.debug((Object)"using default file based HtmlPreviewAdapter factory");
            FileBasedPreviewAdapterFactory factory = new FileBasedPreviewAdapterFactory();
            return factory.getAdapter(doc);
        }
        return null;
    }

    @Override
    public MimeTypePreviewer getPreviewer(String mimeType) {
        for (Map.Entry<String, MimeTypePreviewer> entry : this.previewerFactory.entrySet()) {
            if (!mimeType.matches(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public List<BlobPostProcessor> getBlobPostProcessors() {
        return Collections.unmodifiableList(this.blobPostProcessors);
    }
}

