/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.preview.adapter.base;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.preview.adapter.BlobPostProcessor;
import org.nuxeo.ecm.platform.preview.adapter.PreviewAdapterManager;
import org.nuxeo.ecm.platform.preview.api.HtmlPreviewAdapter;
import org.nuxeo.ecm.platform.preview.api.PreviewException;
import org.nuxeo.ecm.platform.preview.helper.PreviewHelper;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractHtmlPreviewAdapter
implements HtmlPreviewAdapter {
    private static final String TITLE_REGEXP = "<title>(.*?)</title>";
    private static final Pattern TITLE_PATTERN = Pattern.compile("<title>(.*?)</title>", 2);
    protected DocumentModel adaptedDoc;
    protected static PreviewAdapterManager previewManager;

    protected PreviewAdapterManager getPreviewManager() {
        if (previewManager == null) {
            previewManager = (PreviewAdapterManager)Framework.getService(PreviewAdapterManager.class);
        }
        return previewManager;
    }

    @Override
    public void setAdaptedDocument(DocumentModel doc) {
        this.adaptedDoc = doc;
    }

    @Override
    public String getFilePreviewURL() {
        return PreviewHelper.getPreviewURL(this.adaptedDoc);
    }

    @Override
    public String getFilePreviewURL(String xpath) {
        return PreviewHelper.getPreviewURL(this.adaptedDoc, xpath);
    }

    protected String updateTitleInHtml(String htmlContent) throws ClientException {
        Matcher m = TITLE_PATTERN.matcher(htmlContent);
        if (m.find()) {
            String found = m.group();
            htmlContent = htmlContent.replaceFirst(found, "<title>" + this.getPreviewTitle() + "</title>");
        }
        return htmlContent;
    }

    protected void updateTitleInHtml(File file) throws IOException, ClientException {
        String htmlContent = FileUtils.readFile((File)file);
        htmlContent = this.updateTitleInHtml(htmlContent);
        FileUtils.writeFile((File)file, (String)htmlContent);
    }

    protected String getPreviewTitle() throws ClientException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.adaptedDoc.getTitle());
        sb.append(" ");
        String vl = this.adaptedDoc.getVersionLabel();
        if (vl != null) {
            sb.append(vl);
        }
        sb.append(" (preview)");
        return sb.toString();
    }

    @Override
    public List<Blob> getFilePreviewBlobs() throws PreviewException {
        return this.getFilePreviewBlobs(false);
    }

    @Override
    public List<Blob> getFilePreviewBlobs(String xpath) throws PreviewException {
        return this.getFilePreviewBlobs(xpath, false);
    }

    @Override
    public List<Blob> getFilePreviewBlobs(boolean postProcess) throws PreviewException {
        List<Blob> blobs = this.getPreviewBlobs();
        if (postProcess) {
            blobs = this.postProcessBlobs(blobs);
        }
        return blobs;
    }

    protected abstract List<Blob> getPreviewBlobs() throws PreviewException;

    @Override
    public List<Blob> getFilePreviewBlobs(String xpath, boolean postProcess) throws PreviewException {
        List<Blob> blobs = this.getPreviewBlobs(xpath);
        if (postProcess) {
            blobs = this.postProcessBlobs(blobs);
        }
        return blobs;
    }

    protected abstract List<Blob> getPreviewBlobs(String var1) throws PreviewException;

    protected List<Blob> postProcessBlobs(List<Blob> blobs) throws PreviewException {
        ArrayList<Blob> processedBlobs = new ArrayList<Blob>();
        for (Blob blob : blobs) {
            for (BlobPostProcessor processor : this.getPreviewManager().getBlobPostProcessors()) {
                blob = processor.process(blob);
            }
            processedBlobs.add(blob);
        }
        return processedBlobs;
    }
}

