/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.filemanager;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.remoting.WebRemote;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.common.utils.Base64;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.RecoverableClientException;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.UserAction;
import org.nuxeo.ecm.platform.ui.web.util.files.FileUtils;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.ExceptionHelper;
import org.nuxeo.ecm.webapp.clipboard.ClipboardActions;
import org.nuxeo.ecm.webapp.contentbrowser.DocumentActions;
import org.nuxeo.ecm.webapp.filemanager.FileManageActions;
import org.nuxeo.ecm.webapp.filemanager.NxUploadedFile;
import org.nuxeo.ecm.webapp.filemanager.UploadItemHolder;
import org.nuxeo.ecm.webapp.filemanager.UploadItemHolderCycleManager;
import org.nuxeo.ecm.webapp.helpers.EventManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.streaming.FileSource;
import org.nuxeo.runtime.services.streaming.StreamSource;
import org.richfaces.event.FileUploadEvent;

@Name(value="FileManageActions")
@Scope(value=ScopeType.EVENT)
@Install(precedence=10)
public class FileManageActionsBean
implements FileManageActions {
    private static final Log log = LogFactory.getLog(FileManageActionsBean.class);
    public static final String TRANSF_ERROR = "TRANSF_ERROR";
    public static final String SECURITY_ERROR = "SECURITY_ERROR";
    public static final String MOVE_ERROR = "MOVE_ERROR";
    public static final String COPY_ERROR = "COPY_ERROR";
    public static final String PASTE_ERROR = "PASTE_ERROR";
    public static final String MOVE_IMPOSSIBLE = "MOVE_IMPOSSIBLE";
    public static final String MOVE_PUBLISH = "MOVE_PUBLISH";
    public static final String MOVE_OK = "MOVE_OK";
    protected static final String FILES_SCHEMA = "files";
    protected static final String FILES_PROPERTY = "files:files";
    protected static final String SECTION_DOCTYPE = "Section";
    @In(create=true, required=false)
    protected CoreSession documentManager;
    @In(create=true)
    protected TypeManager typeManager;
    @In(create=true)
    protected NavigationContext navigationContext;
    @In(create=true)
    protected transient DocumentActions documentActions;
    @In(create=true)
    protected ClipboardActions clipboardActions;
    @In(create=true, required=false)
    protected UploadItemHolder fileUploadHolder;
    @In(create=true, required=false)
    protected UploadItemHolderCycleManager fileUploadHolderCycle;
    protected String fileToRemove;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected Map<String, String> messages;
    protected FileManager fileManager;

    protected FileManager getFileManagerService() throws ClientException {
        if (this.fileManager == null) {
            try {
                this.fileManager = (FileManager)Framework.getService(FileManager.class);
            }
            catch (Exception e) {
                log.error((Object)"Unable to get FileManager service ", (Throwable)e);
                throw new ClientException("Unable to get FileManager service ", (Throwable)e);
            }
        }
        return this.fileManager;
    }

    @Override
    public String display() {
        return "view_documents";
    }

    @Override
    public String addFile() throws ClientException {
        NxUploadedFile uploadedFile = this.fileUploadHolder.getUploadedFiles().iterator().next();
        File tempFile = uploadedFile.getFile();
        String fileName = uploadedFile.getName();
        if (tempFile == null || fileName == null) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, this.messages.get("fileImporter.error.nullUploadedFile"), new Object[0]);
            return this.navigationContext.getActionResult(this.navigationContext.getCurrentDocument(), UserAction.AFTER_CREATE);
        }
        fileName = FileUtils.getCleanFileName((String)fileName);
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        String path = currentDocument.getPathAsString();
        Blob blob = FileUtils.createTemporaryFileBlob((File)tempFile, (String)fileName, null);
        DocumentModel createdDoc = null;
        try {
            createdDoc = this.getFileManagerService().createDocumentFromBlob(this.documentManager, blob, path, true, fileName);
        }
        catch (IOException e) {
            throw new ClientException("Can not write blob for" + fileName, (Throwable)e);
        }
        EventManager.raiseEventsOnDocumentSelected((DocumentModel)createdDoc);
        Events.instance().raiseEvent("documentChildrenChanged", new Object[]{currentDocument});
        this.facesMessages.add(StatusMessage.Severity.INFO, this.messages.get("document_saved"), new Object[]{this.messages.get(createdDoc.getType())});
        return this.navigationContext.getActionResult(createdDoc, UserAction.AFTER_CREATE);
    }

    @Override
    @Deprecated
    @WebRemote
    public boolean canWrite() throws ClientException {
        return true;
    }

    protected String getErrorMessage(String errorType, String errorInfo) {
        return this.getErrorMessage(errorType, errorInfo, "message.operation.fails.generic");
    }

    protected String getErrorMessage(String errorType, String errorInfo, String errorLabel) {
        return String.format("%s |(%s)| %s", errorType, errorInfo, this.messages.get(errorLabel));
    }

    @Override
    @Deprecated
    @WebRemote
    public String addFileFromPlugin(String content, String mimetype, String fullName, String morePath, Boolean UseBase64) throws ClientException {
        try {
            byte[] bcontent = UseBase64 != false ? Base64.decode((String)content) : content.getBytes();
            return this.addBinaryFileFromPlugin(bcontent, mimetype, fullName, morePath);
        }
        catch (ClientException e) {
            throw new RecoverableClientException("Cannot validate, caught client exception", "message.operation.fails.generic", null, (Throwable)e);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof RecoverableClientException) {
                throw e;
            }
            throw new RecoverableClientException("Cannot validate, caught runtime", "error.db.fs", null, (Throwable)e);
        }
    }

    @WebRemote
    public String addBinaryFileFromPlugin(Blob blob, String fullName, String morePath) throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        String curPath = currentDocument.getPathAsString();
        String path = curPath + morePath;
        return this.createDocumentFromBlob(blob, fullName, path);
    }

    @WebRemote
    public String addBinaryFileFromPlugin(Blob blob, String fullName, DocumentModel targetContainer) throws ClientException {
        return this.createDocumentFromBlob(blob, fullName, targetContainer.getPathAsString());
    }

    protected String createDocumentFromBlob(Blob blob, String fullName, String path) throws ClientException {
        DocumentModel createdDoc;
        try {
            createdDoc = this.getFileManagerService().createDocumentFromBlob(this.documentManager, blob, path, true, fullName);
        }
        catch (Throwable t) {
            Throwable unwrappedError = ExceptionHelper.unwrapException((Throwable)t);
            if (ExceptionHelper.isSecurityError((Throwable)unwrappedError)) {
                log.debug((Object)("No permissions creating " + fullName));
                return this.getErrorMessage(SECURITY_ERROR, fullName, "Error.Insuffisant.Rights");
            }
            log.error((Object)("Error importing " + fullName), t);
            return this.getErrorMessage(TRANSF_ERROR, fullName);
        }
        if (createdDoc == null) {
            log.error((Object)("could not create the document " + fullName));
            return this.getErrorMessage(TRANSF_ERROR, fullName);
        }
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (currentDocument.getRef().equals(createdDoc.getRef())) {
            this.navigationContext.updateDocumentContext(createdDoc);
        }
        Events.instance().raiseEvent("documentChildrenChanged", new Object[]{currentDocument});
        EventManager.raiseEventsOnDocumentSelected((DocumentModel)createdDoc);
        return createdDoc.getName();
    }

    @Deprecated
    public String addBinaryFileFromPlugin(byte[] content, String mimetype, String fullName, String morePath) throws ClientException {
        StreamingBlob blob = StreamingBlob.createFromByteArray((byte[])content, null);
        return this.addBinaryFileFromPlugin((Blob)blob, fullName, morePath);
    }

    @Override
    @WebRemote
    public String addFolderFromPlugin(String fullName, String morePath) throws ClientException {
        try {
            DocumentModel createdDoc;
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            String curPath = currentDocument.getPathAsString();
            if (!currentDocument.isFolder()) {
                curPath = curPath.substring(0, curPath.lastIndexOf(47));
            }
            String path = curPath + morePath;
            try {
                createdDoc = this.getFileManagerService().createFolder(this.documentManager, fullName, path);
            }
            catch (Throwable t) {
                Throwable unwrappedError = ExceptionHelper.unwrapException((Throwable)t);
                if (ExceptionHelper.isSecurityError((Throwable)unwrappedError)) {
                    log.debug((Object)("No permissions creating folder " + fullName));
                    return this.getErrorMessage(SECURITY_ERROR, fullName, "Error.Insuffisant.Rights");
                }
                log.error((Object)("Couldn't create the folder " + fullName));
                return this.getErrorMessage(TRANSF_ERROR, fullName);
            }
            if (createdDoc == null) {
                log.error((Object)("Couldn't create the folder " + fullName));
                return this.getErrorMessage(TRANSF_ERROR, fullName);
            }
            EventManager.raiseEventsOnDocumentSelected((DocumentModel)createdDoc);
            Events.instance().raiseEvent("documentChildrenChanged", new Object[]{currentDocument});
            return createdDoc.getName();
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof RecoverableClientException) {
                throw e;
            }
            throw new RecoverableClientException("Cannot validate, caught runtime", "error.db.fs", null, (Throwable)e);
        }
    }

    @WebRemote
    protected String checkMoveAllowed(DocumentRef docRef, DocumentRef containerRef) throws ClientException {
        DocumentModel doc = this.documentManager.getDocument(docRef);
        DocumentModel container = this.documentManager.getDocument(containerRef);
        if ((container.getPathAsString() + "/").startsWith(doc.getPathAsString() + "/")) {
            this.facesMessages.add(StatusMessage.Severity.WARN, this.messages.get("move_impossible"), new Object[0]);
            return MOVE_IMPOSSIBLE;
        }
        if (!doc.isProxy() && container.hasFacet("PublishSpace") && !doc.hasFacet("PublishSpace")) {
            if (!this.documentManager.hasPermission(containerRef, "AddChildren")) {
                this.facesMessages.add(StatusMessage.Severity.WARN, this.messages.get("move_insuffisant_rights"), new Object[0]);
                return MOVE_IMPOSSIBLE;
            }
            if (doc.hasFacet("Publishable")) {
                return MOVE_PUBLISH;
            }
            this.facesMessages.add(StatusMessage.Severity.WARN, this.messages.get("publish_impossible"), new Object[0]);
            return MOVE_IMPOSSIBLE;
        }
        if (!this.documentManager.hasPermission(doc.getParentRef(), "RemoveChildren") || !this.documentManager.hasPermission(doc.getRef(), "Remove")) {
            this.facesMessages.add(StatusMessage.Severity.WARN, this.messages.get("move_impossible"), new Object[0]);
            return MOVE_IMPOSSIBLE;
        }
        if (!this.documentManager.hasPermission(containerRef, "AddChildren")) {
            this.facesMessages.add(StatusMessage.Severity.WARN, this.messages.get("move_insuffisant_rights"), new Object[0]);
            return MOVE_IMPOSSIBLE;
        }
        if (doc.isProxy()) {
            if (!container.hasFacet("PublishSpace")) {
                this.facesMessages.add(StatusMessage.Severity.WARN, this.messages.get("move_impossible"), new Object[0]);
                return MOVE_IMPOSSIBLE;
            }
        } else if (!this.typeManager.isAllowedSubType(doc.getType(), container.getType(), container)) {
            this.facesMessages.add(StatusMessage.Severity.WARN, this.messages.get("move_impossible"), new Object[0]);
            return MOVE_IMPOSSIBLE;
        }
        return MOVE_OK;
    }

    @Override
    @WebRemote
    public String moveWithId(String docId, String containerId) throws ClientException {
        try {
            IdRef dstRef;
            String moveStatus;
            String debug = "move " + docId + " into " + containerId;
            log.debug((Object)debug);
            if (docId.startsWith("docRef:")) {
                docId = docId.split("docRef:")[1];
            }
            if (docId.startsWith("docClipboardRef:")) {
                docId = docId.split("docClipboardRef:")[1];
            }
            IdRef srcRef = new IdRef(docId);
            String dst = containerId;
            if (dst.startsWith("docRef:")) {
                dst = dst.split("docRef:")[1];
            }
            if (dst.startsWith("nodeRef:")) {
                dst = dst.split("nodeRef:")[1];
            }
            if ((moveStatus = this.checkMoveAllowed((DocumentRef)srcRef, (DocumentRef)(dstRef = new IdRef(dst)))).equals(MOVE_IMPOSSIBLE)) {
                return debug;
            }
            String action = "document_moved";
            if (moveStatus.equals(MOVE_PUBLISH)) {
                DocumentModel srcDoc = this.documentManager.getDocument((DocumentRef)srcRef);
                DocumentModel dstDoc = this.documentManager.getDocument((DocumentRef)dstRef);
                this.documentManager.publishDocument(srcDoc, dstDoc);
                action = "document_published";
            } else {
                this.documentManager.move((DocumentRef)srcRef, (DocumentRef)dstRef, null);
            }
            this.documentManager.save();
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            EventManager.raiseEventsOnDocumentChildrenChange((DocumentModel)currentDocument);
            Events.instance().raiseEvent("documentChildrenChanged", new Object[]{currentDocument});
            DocumentModel otherContainer = this.documentManager.getDocument((DocumentRef)dstRef);
            Events.instance().raiseEvent("documentChildrenChanged", new Object[]{otherContainer});
            this.facesMessages.add(StatusMessage.Severity.INFO, this.messages.get(action), new Object[]{this.messages.get(this.documentManager.getDocument((DocumentRef)srcRef).getType())});
            return debug;
        }
        catch (ClientException e) {
            throw new RecoverableClientException("Cannot validate, caught client exception", "message.operation.fails.generic", null, (Throwable)e);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof RecoverableClientException) {
                throw e;
            }
            throw new RecoverableClientException("Cannot validate, caught runtime", "error.db.fs", null, (Throwable)e);
        }
    }

    @Override
    @WebRemote
    public String copyWithId(String docId) throws ClientException {
        try {
            String debug = "copying " + docId;
            log.debug((Object)debug);
            if (docId.startsWith("docRef:")) {
                docId = docId.split("docRef:")[1];
            }
            if (docId.startsWith("docClipboardRef:")) {
                docId = docId.split("docClipboardRef:")[1];
            }
            IdRef srcRef = new IdRef(docId);
            DocumentModel srcDoc = this.documentManager.getDocument((DocumentRef)srcRef);
            ArrayList<DocumentModel> docsToAdd = new ArrayList<DocumentModel>();
            docsToAdd.add(srcDoc);
            this.clipboardActions.putSelectionInWorkList(docsToAdd, Boolean.TRUE);
            return debug;
        }
        catch (ClientException e) {
            throw new RecoverableClientException("Cannot validate, caught client exception", "message.operation.fails.generic", null, (Throwable)e);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof RecoverableClientException) {
                throw e;
            }
            throw new RecoverableClientException("Cannot validate, caught runtime", "error.db.fs", null, (Throwable)e);
        }
    }

    @Override
    @WebRemote
    public String pasteWithId(String docId) throws ClientException {
        try {
            String debug = "pasting " + docId;
            log.debug((Object)debug);
            if (docId.startsWith("pasteRef_")) {
                docId = docId.split("pasteRef_")[1];
            }
            if (docId.startsWith("docClipboardRef:")) {
                docId = docId.split("docClipboardRef:")[1];
            }
            IdRef srcRef = new IdRef(docId);
            DocumentModel srcDoc = this.documentManager.getDocument((DocumentRef)srcRef);
            ArrayList<DocumentModel> pasteDocs = new ArrayList<DocumentModel>();
            pasteDocs.add(srcDoc);
            this.clipboardActions.pasteDocumentList(pasteDocs);
            return debug;
        }
        catch (ClientException e) {
            throw new RecoverableClientException("Cannot validate, caught client exception", "message.operation.fails.generic", null, (Throwable)e);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof RecoverableClientException) {
                throw e;
            }
            throw new RecoverableClientException("Cannot validate, caught runtime", "error.db.fs", null, (Throwable)e);
        }
    }

    public void processUpload(FileUploadEvent uploadEvent) {
        try {
            if (this.fileUploadHolder != null) {
                Collection<NxUploadedFile> temp = this.fileUploadHolder.getUploadedFiles();
                File file = null;
                String jstTmpFileDir = Framework.getProperty((String)"nuxeo.jsf.tmp.dir");
                file = StringUtils.isNotBlank((String)jstTmpFileDir) ? File.createTempFile("FileManageActionsFile", null, new File(jstTmpFileDir)) : File.createTempFile("FileManageActionsFile", null);
                InputStream in = uploadEvent.getUploadedFile().getInputStream();
                org.nuxeo.common.utils.FileUtils.copyToFile((InputStream)in, (File)file);
                temp.add(new NxUploadedFile(uploadEvent.getUploadedFile().getName(), uploadEvent.getUploadedFile().getContentType(), file));
                this.fileUploadHolder.setUploadedFiles(temp);
            } else {
                log.error((Object)"Unable to reach fileUploadHolder");
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public void validateMultiplesUpload() throws ClientException, FileNotFoundException, IOException {
        DocumentModel current = this.navigationContext.getCurrentDocument();
        this.validateMultipleUploadForDocument(current);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateMultipleUploadForDocument(DocumentModel current) throws ClientException, FileNotFoundException, IOException {
        if (!current.hasSchema(FILES_SCHEMA)) {
            return;
        }
        Collection<NxUploadedFile> nxuploadFiles = this.getUploadedFiles();
        try {
            ArrayList files = (ArrayList)current.getPropertyValue(FILES_PROPERTY);
            if (nxuploadFiles != null) {
                for (NxUploadedFile uploadItem : nxuploadFiles) {
                    String filename = FileUtils.getCleanFileName((String)uploadItem.getName());
                    Blob blob = FileUtils.createTemporaryFileBlob((File)uploadItem.getFile(), (String)filename, (String)uploadItem.getContentType());
                    HashMap<String, Object> fileMap = new HashMap<String, Object>(2);
                    fileMap.put("file", blob);
                    fileMap.put("filename", filename);
                    if (files.contains(fileMap)) continue;
                    files.add(fileMap);
                }
            }
            current.setPropertyValue(FILES_PROPERTY, (Serializable)files);
            this.documentActions.updateDocument(current, Boolean.TRUE);
        }
        finally {
            if (nxuploadFiles != null) {
                for (NxUploadedFile uploadItem : nxuploadFiles) {
                    File tempFile = uploadItem.getFile();
                    if (tempFile == null || !tempFile.exists()) continue;
                    Framework.trackFile((File)tempFile, (Object)tempFile);
                }
            }
        }
    }

    public void performAction(ActionEvent event) {
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext eContext = context.getExternalContext();
        String index = (String)eContext.getRequestParameterMap().get("index");
        try {
            DocumentModel current = this.navigationContext.getCurrentDocument();
            if (!current.hasSchema(FILES_SCHEMA)) {
                return;
            }
            ArrayList files = (ArrayList)current.getPropertyValue(FILES_PROPERTY);
            Object file = CollectionUtils.get((Object)files, (int)Integer.valueOf(index));
            files.remove(file);
            current.setPropertyValue(FILES_PROPERTY, (Serializable)files);
            this.documentActions.updateDocument(current, Boolean.TRUE);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public String validate() throws ClientException {
        NxUploadedFile uploadedFile;
        if (this.fileUploadHolder == null || this.fileUploadHolder.getUploadedFiles().isEmpty() || (uploadedFile = this.fileUploadHolder.getUploadedFiles().iterator().next()) == null) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, this.messages.get("fileImporter.error.nullUploadedFile"), new Object[0]);
            return null;
        }
        try {
            String string = this.addFile();
            return string;
        }
        catch (ClientException e) {
            throw new RecoverableClientException("Cannot validate, caught client exception", "message.operation.fails.generic", null, (Throwable)e);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof RecoverableClientException) {
                throw e;
            }
            throw new RecoverableClientException("Cannot validate, caught runtime", "error.db.fs", null, (Throwable)e);
        }
        finally {
            if (uploadedFile != null && uploadedFile.getFile().exists()) {
                Framework.trackFile((File)uploadedFile.getFile(), (Object)uploadedFile.getFile());
            }
        }
    }

    @Override
    public InputStream getFileUpload() {
        if (this.fileUploadHolder != null) {
            return this.fileUploadHolder.getFileUpload();
        }
        return null;
    }

    @Override
    public void setFileUpload(InputStream fileUpload) {
        if (this.fileUploadHolder != null) {
            this.fileUploadHolder.setFileUpload(fileUpload);
        }
    }

    @Override
    public String getFileName() {
        if (this.fileUploadHolder != null) {
            return this.fileUploadHolder.getFileName();
        }
        return null;
    }

    @Override
    public void setFileName(String fileName) {
        if (this.fileUploadHolder != null) {
            this.fileUploadHolder.setFileName(fileName);
        }
    }

    public DocumentModel getChangeableDocument() {
        return this.navigationContext.getChangeableDocument();
    }

    public void setChangeableDocument(DocumentModel changeableDocument) {
        this.navigationContext.setChangeableDocument(changeableDocument);
    }

    public Collection<NxUploadedFile> getUploadedFiles() {
        if (this.fileUploadHolder != null) {
            return this.fileUploadHolder.getUploadedFiles();
        }
        return null;
    }

    public void setUploadedFiles(Collection<NxUploadedFile> uploadedFiles) {
        if (this.fileUploadHolder != null) {
            this.fileUploadHolder.setUploadedFiles(uploadedFiles);
        }
    }

    @Override
    @WebRemote
    public String removeSingleUploadedFile() throws ClientException {
        return this.removeAllUploadedFile();
    }

    @Override
    public void setFileToRemove(String fileToRemove) {
        this.fileToRemove = fileToRemove;
    }

    @Override
    public String removeOneOrAllUploadedFiles(ActionEvent action) throws ClientException {
        if (StringUtils.isBlank((String)this.fileToRemove)) {
            return this.removeAllUploadedFile();
        }
        return this.removeUploadedFile(this.fileToRemove);
    }

    @Override
    @WebRemote
    public String removeAllUploadedFile() throws ClientException {
        if (this.fileUploadHolder != null) {
            Collection<NxUploadedFile> files = this.getUploadedFiles();
            if (files != null) {
                for (NxUploadedFile item : files) {
                    item.getFile().delete();
                }
            }
            this.setUploadedFiles(new ArrayList<NxUploadedFile>());
        }
        return "";
    }

    @Override
    @WebRemote
    public String removeUploadedFile(String fileName) throws ClientException {
        NxUploadedFile fileToDelete = null;
        fileName = FilenameUtils.getName((String)fileName);
        Collection<NxUploadedFile> files = this.getUploadedFiles();
        if (files != null) {
            for (NxUploadedFile file : files) {
                String uploadedFileName = file.getName();
                if (!fileName.equals(uploadedFileName)) continue;
                fileToDelete = file;
                break;
            }
        }
        if (fileToDelete != null) {
            fileToDelete.getFile().delete();
            files.remove(fileToDelete);
            this.setUploadedFiles(files);
        }
        return "";
    }

    @Deprecated
    protected static Blob createTemporaryFileBlob(File file, String filename, String mimeType) {
        return FileUtils.createTemporaryFileBlob((File)file, (String)filename, (String)mimeType);
    }

    @Deprecated
    public static class TemporaryFileBlob
    extends StreamingBlob {
        private static final long serialVersionUID = 1L;

        public TemporaryFileBlob(File file, String mimeType, String encoding, String filename, String digest) {
            super((StreamSource)new FileSource(file), mimeType, encoding, filename, digest);
        }

        public boolean isTemporary() {
            return true;
        }

        public FileSource getStreamSource() {
            return (FileSource)this.src;
        }
    }
}

