/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.tree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.Sorter;
import org.nuxeo.ecm.core.api.quota.QuotaStats;
import org.nuxeo.ecm.core.api.quota.QuotaStatsNonFolderishCount;
import org.nuxeo.ecm.platform.contentview.jsf.ContentView;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.webapp.tree.DocumentTreeNode;
import org.nuxeo.ecm.webapp.tree.TreeActionsBean;
import org.nuxeo.runtime.api.Framework;

public class DocumentTreeNodeImpl
implements DocumentTreeNode {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DocumentTreeNodeImpl.class);
    protected final DocumentModel document;
    protected final Filter filter;
    protected final Filter leafFilter;
    protected final Sorter sorter;
    protected final String pageProviderName;
    protected ContentView orderableContentView;
    protected Map<Object, DocumentTreeNodeImpl> children;
    protected Boolean expanded = null;

    public DocumentTreeNodeImpl(DocumentModel document, Filter filter, Filter leafFilter, Sorter sorter, String pageProviderName) {
        this.document = document;
        this.filter = filter;
        this.leafFilter = leafFilter;
        this.sorter = sorter;
        this.pageProviderName = pageProviderName;
    }

    @Deprecated
    public DocumentTreeNodeImpl(String sessionId, DocumentModel document, Filter filter, Filter leafFilter, Sorter sorter, String pageProviderName) {
        this(document, filter, leafFilter, sorter, pageProviderName);
    }

    @Deprecated
    public DocumentTreeNodeImpl(String sessionId, DocumentModel document, Filter filter, Sorter sorter) {
        this(document, filter, null, sorter, null);
    }

    public DocumentTreeNodeImpl(DocumentModel document, Filter filter, Sorter sorter) {
        this(document, filter, null, sorter, null);
    }

    @Override
    public List<DocumentTreeNode> getChildren() {
        if (this.children == null) {
            this.fetchChildren();
        }
        ArrayList<DocumentTreeNode> childrenNodes = new ArrayList<DocumentTreeNode>();
        childrenNodes.addAll(this.children.values());
        return childrenNodes;
    }

    @Override
    public DocumentModel getDocument() {
        return this.document;
    }

    @Override
    public String getId() {
        if (this.document != null) {
            return this.document.getId();
        }
        return null;
    }

    @Override
    public boolean isSelected(DocumentModel currentDocument) {
        if (currentDocument != null) {
            if (!currentDocument.isFolder()) {
                String currentPath = currentDocument.getPathAsString();
                String nodePath = this.getPath();
                if (currentPath != null && nodePath != null && currentPath.startsWith(nodePath) && currentPath.length() > nodePath.length() && !currentPath.substring(nodePath.length() + 1).contains("/")) {
                    return true;
                }
            } else {
                return currentDocument.getId().equals(this.getId());
            }
        }
        return false;
    }

    @Override
    public String getPath() {
        if (this.document != null) {
            return this.document.getPathAsString();
        }
        return null;
    }

    @Override
    public void resetChildren() {
        this.children = null;
    }

    @Override
    public void fetchChildren() {
        try {
            Object documents;
            this.children = new LinkedHashMap<Object, DocumentTreeNodeImpl>();
            if (this.leafFilter != null && this.leafFilter.accept(this.document)) {
                return;
            }
            CoreSession session = this.getCoreSession();
            if (session == null) {
                log.error((Object)("Cannot retrieve CoreSession for " + this.document));
                return;
            }
            boolean isOrderable = this.document.hasFacet("Orderable");
            if (this.pageProviderName == null) {
                Sorter sorterToUse = isOrderable ? null : this.sorter;
                documents = session.getChildren(this.document.getRef(), null, "Read", this.filter, sorterToUse);
            } else {
                PageProviderService ppService = (PageProviderService)Framework.getService(PageProviderService.class);
                ArrayList<SortInfo> sortInfos = null;
                HashMap<String, Serializable> props = new HashMap<String, Serializable>();
                props.put("coreSession", (Serializable)session);
                if (isOrderable) {
                    sortInfos = new ArrayList<SortInfo>();
                    sortInfos.add(new SortInfo("ecm:pos", true));
                }
                PageProvider pp = ppService.getPageProvider(this.pageProviderName, sortInfos, null, null, props, new Object[]{this.getId()});
                documents = pp.getCurrentPage();
                documents = this.filterAndSort((List<DocumentModel>)documents, !isOrderable);
            }
            for (DocumentModel child : documents) {
                String identifier = child.getId();
                DocumentTreeNodeImpl childNode = new DocumentTreeNodeImpl(child, this.filter, this.leafFilter, this.sorter, this.pageProviderName);
                this.children.put(identifier, childNode);
            }
        }
        catch (ClientException e) {
            log.error((Object)e);
        }
    }

    protected CoreSession getCoreSession() {
        CoreSession session = this.document.getCoreSession();
        if (session == null) {
            session = (CoreSession)Component.getInstance((String)"documentManager", (ScopeType)ScopeType.CONVERSATION);
        }
        return session;
    }

    protected List<DocumentModel> filterAndSort(List<DocumentModel> docs, boolean doSort) {
        ArrayList<DocumentModel> res = new ArrayList<DocumentModel>();
        if (docs != null) {
            if (this.filter == null) {
                res.addAll(docs);
            } else {
                for (DocumentModel doc : docs) {
                    if (!this.filter.accept(doc)) continue;
                    res.add(doc);
                }
            }
        }
        if (this.sorter != null && doSort) {
            Collections.sort(res, this.sorter);
        }
        return res;
    }

    @Override
    public QuotaStats getQuotaStats() {
        return this.document != null ? (QuotaStatsNonFolderishCount)this.document.getAdapter(QuotaStatsNonFolderishCount.class) : null;
    }

    @Override
    public boolean isExpanded() {
        String currentDocPath;
        TreeActionsBean treeActionBean;
        if (this.expanded == null && !(treeActionBean = (TreeActionsBean)Component.getInstance((String)"treeActions")).isNodeExpandEvent() && (currentDocPath = treeActionBean.getCurrentDocumentPath()) != null && this.getPath() != null && currentDocPath.startsWith(this.getPath()) && ((currentDocPath + '/').startsWith(this.getPath() + '/') || "/".equals(this.getPath()))) {
            this.expanded = Boolean.TRUE;
        }
        return Boolean.TRUE.equals(this.expanded);
    }

    @Override
    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }
}

