/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.notification;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.datamodel.DataModel;
import org.jboss.seam.annotations.datamodel.DataModelSelection;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.notification.api.Notification;
import org.nuxeo.ecm.platform.notification.api.NotificationManager;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.webapp.base.InputController;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.ecm.webapp.notification.SelectableSubscription;

@Name(value="subscriptionAction")
@Scope(value=ScopeType.PAGE)
public class SubscriptionsAction
extends InputController
implements Serializable {
    private static final long serialVersionUID = -2440187703248677446L;
    private static final Log log = LogFactory.getLog(SubscriptionsAction.class);
    @In
    protected transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @DataModel(value="notificationList")
    protected List<SelectableSubscription> notificationList;
    @DataModel(value="inheritedNotifications")
    private List<Notification> inheritedNotifications;
    @DataModelSelection(value="notificationList")
    private SelectableSubscription currentSubscription;
    @In(create=true)
    protected transient NotificationManager notificationManager;
    @In(create=true, required=false)
    protected transient FacesMessages facesMessages;
    @In(create=true)
    protected ResourcesAccessor resourcesAccessor;
    public static final String CONFIRM_FOLLOW = "label.subscriptions.follow.confirm";
    public static final String CONFIRM_UNFOLLOW = "label.subscriptions.unfollow.confirm";

    @Factory(value="notificationList")
    public void getNotificationsList() throws ClientException {
        log.debug((Object)"Factory for notifications list");
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        String superParentType = this.documentManager.getSuperParentType(currentDocument);
        List notifs = this.notificationManager.getNotificationsForSubscriptions(superParentType);
        List<String> subscriptions = this.getSelectedNotifications();
        log.debug((Object)("Selected notifications : " + subscriptions));
        ArrayList<SelectableSubscription> notifsResult = new ArrayList<SelectableSubscription>();
        for (Notification notification : notifs) {
            String notifName = notification.getName();
            if (subscriptions.contains(notifName)) {
                notifsResult.add(new SelectableSubscription(true, notification));
                continue;
            }
            notifsResult.add(new SelectableSubscription(false, notification));
        }
        this.notificationList = notifsResult;
    }

    @Factory(value="inheritedNotifications")
    public void loadInheritedNotifications() throws ClientException, ClassNotFoundException {
        this.inheritedNotifications = new ArrayList<Notification>();
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        NuxeoPrincipal principal = (NuxeoPrincipal)FacesContext.getCurrentInstance().getExternalContext().getUserPrincipal();
        for (String group : principal.getAllGroups()) {
            List notifs = this.notificationManager.getSubscriptionsForUserOnDocument("group:" + group, currentDoc.getId());
            for (String inheritedNotification : notifs) {
                Notification notif = this.notificationManager.getNotificationByName(inheritedNotification);
                this.inheritedNotifications.add(notif);
            }
        }
    }

    public void updateSubscriptions() throws ClientException {
        NuxeoPrincipal principal = (NuxeoPrincipal)FacesContext.getCurrentInstance().getExternalContext().getUserPrincipal();
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        if (this.currentSubscription.isSelected()) {
            this.notificationManager.removeSubscription("user:" + principal.getName(), this.currentSubscription.getNotification().getName(), currentDoc.getId());
        } else {
            this.notificationManager.addSubscription("user:" + principal.getName(), this.currentSubscription.getNotification().getName(), currentDoc, Boolean.valueOf(false), principal, "");
        }
        this.getNotificationsList();
    }

    public void updateAllSubscriptions() {
        NuxeoPrincipal principal = (NuxeoPrincipal)FacesContext.getCurrentInstance().getExternalContext().getUserPrincipal();
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        List userSubscriptions = this.notificationManager.getSubscriptionsForUserOnDocument("user:" + principal.getName(), currentDoc.getId());
        if (userSubscriptions.size() == 0) {
            this.notificationManager.addSubscriptions("user:" + principal.getName(), currentDoc, Boolean.valueOf(false), principal);
            this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get(CONFIRM_FOLLOW), new Object[0]);
        } else {
            this.notificationManager.removeSubscriptions("user:" + principal.getName(), userSubscriptions, currentDoc.getId());
            this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get(CONFIRM_UNFOLLOW), new Object[0]);
        }
        this.getNotificationsList();
    }

    @Observer(value={"documentSelectionChanged"}, create=false)
    @BypassInterceptors
    public void invalidateNotificationsSelection() {
        log.debug((Object)"Invalidate archive records.................");
        this.notificationList = null;
        this.currentSubscription = null;
        this.inheritedNotifications = null;
    }

    public List<String> getSelectedNotifications() throws ClientException {
        return this.getSubscriptionsForCurrentUser();
    }

    private List<String> getSubscriptionsForCurrentUser() throws ClientException {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        NuxeoPrincipal principal = (NuxeoPrincipal)FacesContext.getCurrentInstance().getExternalContext().getUserPrincipal();
        List subscriptions = this.notificationManager.getSubscriptionsForUserOnDocument("user:" + principal.getName(), currentDoc.getId());
        return subscriptions;
    }

    public SelectableSubscription getCurrentSubscription() {
        return this.currentSubscription;
    }

    public void setCurrentSubscription(SelectableSubscription currentSubscription) {
        this.currentSubscription = currentSubscription;
    }

    public List<SelectableSubscription> getNotificationList() {
        return this.notificationList;
    }

    public void setNotificationList(List<SelectableSubscription> notificationList) {
        this.notificationList = notificationList;
    }

    public List<Notification> getInheritedNotifications() {
        return this.inheritedNotifications;
    }

    public void setInheritedNotifications(List<Notification> inheritedNotifications) {
        this.inheritedNotifications = inheritedNotifications;
    }
}

