/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.collections.core.automation;

import java.util.Map;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationParameters;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.jaxrs.io.documents.PaginableDocumentModelListImpl;
import org.nuxeo.ecm.core.api.DocumentModel;

@Operation(id="Collection.GetDocumentsFromCollection", category="Document", label="Get documents from collection", description="Get the list of documents visible by the currentUser in a collection. This is returning a list of documents.")
public class GetDocumentsFromCollectionOperation {
    public static final String ID = "Collection.GetDocumentsFromCollection";
    @Context
    protected OperationContext ctx;
    @Context
    protected AutomationService service;

    @OperationMethod
    public PaginableDocumentModelListImpl run(DocumentModel collection) throws OperationException {
        Map vars = this.ctx.getVars();
        vars.put("searchTerm", collection.getId());
        vars.put("providerName", "default_content_collection");
        OperationContext subctx = new OperationContext(this.ctx.getCoreSession(), vars);
        OperationChain chain = new OperationChain("operation");
        OperationParameters oparams = new OperationParameters("Document.PageProvider", vars);
        chain.add(oparams);
        return (PaginableDocumentModelListImpl)this.service.run(subctx, chain);
    }
}

