/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.collections.core.automation;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationParameters;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.collections.api.CollectionManager;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;

@Operation(id="Collection.Suggestion", category="Services", label="Get collection suggestion", description="Get the collection list accessible by the current user. This is returning a blob containing a serialized JSON array..", addToStudio=false)
public class SuggestCollectionEntry {
    public static final String ID = "Collection.Suggestion";
    private static final String PATH = "path";
    @Param(name="currentPageIndex", required=false)
    protected Integer currentPageIndex = 0;
    @Param(name="pageSize", required=false)
    protected Integer pageSize = 20;
    @Context
    protected AutomationService service;
    @Context
    protected OperationContext ctx;
    @Context
    protected CoreSession session;
    @Context
    protected CollectionManager collectionManager;
    @Param(name="lang", required=false)
    protected String lang;
    @Param(name="searchTerm", required=false)
    protected String searchTerm;

    @OperationMethod
    public Blob run() throws OperationException {
        JSONArray result = new JSONArray();
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.session);
        Map vars = this.ctx.getVars();
        StringList sl = new StringList();
        sl.add((Object)(this.searchTerm + (this.searchTerm.endsWith("%") ? "" : "%")));
        sl.add((Object)"$currentUser");
        vars.put("queryParams", sl);
        vars.put("providerName", "default_collection");
        OperationContext subctx = new OperationContext(this.ctx.getCoreSession(), vars);
        OperationChain chain = new OperationChain("operation");
        OperationParameters oparams = new OperationParameters("Document.PageProvider", vars);
        chain.add(oparams);
        List docs = (List)this.service.run(subctx, chain);
        boolean found = false;
        for (DocumentModel doc : docs) {
            JSONObject obj = new JSONObject();
            if (this.collectionManager.canAddToCollection(doc, this.session)) {
                obj.element("id", (Object)doc.getId());
            }
            if (doc.getTitle().equals(this.searchTerm)) {
                found = true;
            }
            obj.element("displayLabel", (Object)doc.getTitle());
            if (StringUtils.isNotBlank((String)((String)doc.getProperty("common", "icon")))) {
                obj.element("icon", doc.getProperty("common", "icon"));
            }
            obj.element(PATH, (Object)doc.getPath().toString());
            result.add((Object)obj);
        }
        if (!found && StringUtils.isNotBlank((String)this.searchTerm)) {
            JSONObject obj = new JSONObject();
            obj.element("displayLabel", (Object)this.searchTerm);
            obj.element("id", (Object)("-999999" + this.searchTerm));
            result.add(0, (Object)obj);
        }
        return new StringBlob(result.toString(), "application/json");
    }

    protected Locale getLocale() {
        return new Locale(this.getLang());
    }

    protected String getLang() {
        if (this.lang == null) {
            this.lang = (String)this.ctx.get((Object)"lang");
            if (this.lang == null) {
                this.lang = "en";
            }
        }
        return this.lang;
    }
}

