/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.impl;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventStats;
import org.nuxeo.ecm.core.event.ReconnectedEventBundle;
import org.nuxeo.ecm.core.event.impl.EventListenerDescriptor;
import org.nuxeo.ecm.core.event.impl.ReconnectedEventBundleImpl;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class PostCommitEventExecutor {
    private static final Log log = LogFactory.getLog(PostCommitEventExecutor.class);
    public static final int DEFAULT_TIMEOUT_MS = 300;
    public static final String DEFAULT_BULK_TIMEOUT_S = "600";
    public static final String BULK_TIMEOUT_PROP = "org.nuxeo.ecm.core.event.tx.BulkExecutor.timeout";
    private static final long KEEP_ALIVE_TIME_SECOND = 10L;
    private static final int MAX_POOL_SIZE = 100;
    protected final ExecutorService executor;

    public PostCommitEventExecutor() {
        NamedThreadFactory threadFactory = new NamedThreadFactory("Nuxeo-Event-PostCommit-");
        this.executor = new ThreadPoolExecutor(0, 100, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
        ((ThreadPoolExecutor)this.executor).allowCoreThreadTimeOut(true);
    }

    public void shutdown(long timeoutMillis) throws InterruptedException {
        this.executor.shutdown();
        this.executor.awaitTermination(timeoutMillis, TimeUnit.MILLISECONDS);
        if (!this.executor.isTerminated()) {
            this.executor.shutdownNow();
        }
    }

    public void run(List<EventListenerDescriptor> listeners, EventBundle event) {
        this.run(listeners, event, 300L, false);
    }

    public void runBulk(List<EventListenerDescriptor> listeners, EventBundle event) {
        String timeoutSeconds = Framework.getProperty((String)BULK_TIMEOUT_PROP, (String)DEFAULT_BULK_TIMEOUT_S);
        this.run(listeners, event, Long.parseLong(timeoutSeconds) * 1000L, true);
    }

    public void run(List<EventListenerDescriptor> listeners, EventBundle bundle, long timeoutMillis, boolean bulk) {
        boolean some = false;
        for (EventListenerDescriptor listener : listeners) {
            if (!listener.acceptBundle(bundle)) continue;
            some = true;
            break;
        }
        if (!some) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Events postcommit execution has nothing to do");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Events postcommit execution starting with timeout %sms%s", timeoutMillis, bulk ? " in bulk mode" : ""));
        }
        Callable<Boolean> callable = !bulk ? new EventBundleRunner(listeners, bundle) : new EventBundleBulkRunner(listeners, bundle);
        FutureTask<Boolean> futureTask = new FutureTask<Boolean>(callable);
        try {
            this.executor.execute(futureTask);
        }
        catch (RejectedExecutionException e) {
            log.error((Object)"Events postcommit execution rejected", (Throwable)e);
            return;
        }
        try {
            Boolean ok = futureTask.get(timeoutMillis, TimeUnit.MILLISECONDS);
            if (Boolean.FALSE.equals(ok)) {
                log.error((Object)"Events postcommit bulk execution aborted due to previous error");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            futureTask.cancel(true);
        }
        catch (TimeoutException e) {
            if (!bulk) {
                log.warn((Object)String.format("Events postcommit execution exceeded timeout of %sms, leaving thread running", timeoutMillis));
            } else {
                log.error((Object)String.format("Events postcommit bulk execution exceeded timeout of %sms, interrupting thread", timeoutMillis));
                futureTask.cancel(true);
            }
        }
        catch (ExecutionException e) {
            log.error((Object)"Events postcommit execution encountered unexpected exception", e.getCause());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Events postcommit execution finished");
        }
    }

    protected static class EventBundleBulkRunner
    implements Callable<Boolean> {
        protected final List<EventListenerDescriptor> listeners;
        protected final EventBundle bundle;

        public EventBundleBulkRunner(List<EventListenerDescriptor> listeners, EventBundle bundle) {
            this.listeners = listeners;
            this.bundle = bundle;
        }

        /*
         * Exception decompiling
         */
        @Override
        public Boolean call() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    protected static class EventBundleRunner
    implements Callable<Boolean> {
        protected final List<EventListenerDescriptor> listeners;
        protected final EventBundle bundle;

        public EventBundleRunner(List<EventListenerDescriptor> listeners, EventBundle bundle) {
            this.listeners = listeners;
            this.bundle = bundle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Events postcommit execution starting in thread: " + Thread.currentThread().getName()));
            }
            long t0 = System.currentTimeMillis();
            EventStats stats = (EventStats)Framework.getLocalService(EventStats.class);
            for (EventListenerDescriptor listener : this.listeners) {
                EventBundle filtered = listener.filterBundle(this.bundle);
                if (filtered.isEmpty()) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Events postcommit execution start for listener: " + listener.getName()));
                }
                long t1 = System.currentTimeMillis();
                boolean ok = false;
                ReconnectedEventBundle reconnected = null;
                boolean tx = TransactionHelper.startTransaction();
                try {
                    reconnected = new ReconnectedEventBundleImpl(filtered, this.listeners.toString());
                    listener.asPostCommitListener().handleEvent(reconnected);
                    if (Thread.currentThread().isInterrupted()) {
                        log.error((Object)("Events postcommit execution interrupted for listener: " + listener.getName()));
                        ok = false;
                        continue;
                    }
                    ok = true;
                }
                catch (ClientException e) {
                    log.error((Object)("Events postcommit execution encountered exception for listener: " + listener.getName()), (Throwable)e);
                }
                catch (RuntimeException e) {
                    log.error((Object)("Events postcommit execution encountered exception for listener: " + listener.getName()), (Throwable)e);
                }
                finally {
                    try {
                        if (reconnected == null) continue;
                        reconnected.disconnect();
                    }
                    finally {
                        if (tx) {
                            if (!ok) {
                                TransactionHelper.setTransactionRollbackOnly();
                                log.error((Object)"Rolling back transaction");
                            }
                            TransactionHelper.commitOrRollbackTransaction();
                        }
                        if (stats != null) {
                            stats.logAsyncExec(listener, System.currentTimeMillis() - t1);
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Events postcommit execution end for listener: " + listener.getName() + " in " + (System.currentTimeMillis() - t1) + "ms"));
                    }
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Events postcommit execution finished in " + (System.currentTimeMillis() - t0) + "ms"));
            }
            return Boolean.TRUE;
        }
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger();
        private final ThreadGroup group;
        private final String prefix;

        public NamedThreadFactory(String prefix) {
            SecurityManager sm = System.getSecurityManager();
            this.group = sm == null ? Thread.currentThread().getThreadGroup() : sm.getThreadGroup();
            this.prefix = prefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            String name = this.prefix + this.threadNumber.incrementAndGet();
            Thread thread = new Thread(this.group, r, name);
            thread.setPriority(5);
            return thread;
        }
    }
}

