/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.scheduler;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.text.ParseException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.scheduler.EventJob;
import org.nuxeo.ecm.core.scheduler.Schedule;
import org.nuxeo.ecm.core.scheduler.ScheduleExtensionRegistry;
import org.nuxeo.ecm.core.scheduler.SchedulerService;
import org.nuxeo.runtime.RuntimeServiceEvent;
import org.nuxeo.runtime.RuntimeServiceListener;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;
import org.nuxeo.runtime.model.RuntimeContext;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

public class SchedulerServiceImpl
extends DefaultComponent
implements SchedulerService,
RuntimeServiceListener {
    private static final Log log = LogFactory.getLog(SchedulerServiceImpl.class);
    protected RuntimeContext bundle;
    protected Scheduler scheduler;
    protected final ScheduleExtensionRegistry registry = new ScheduleExtensionRegistry();

    public void activate(ComponentContext context) {
        log.debug((Object)"Activate");
        this.bundle = context.getRuntimeContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupScheduler(ComponentContext context) throws IOException, SchedulerException {
        String[] jobs;
        StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
        URL cfg = context.getRuntimeContext().getResource("config/quartz.properties");
        if (cfg != null) {
            try (InputStream stream = cfg.openStream();){
                schedulerFactory.initialize(stream);
            }
        } else {
            Properties props = new Properties();
            props.put("org.quartz.scheduler.instanceName", "Quartz");
            props.put("org.quartz.scheduler.threadName", "Quartz_Scheduler");
            props.put("org.quartz.scheduler.instanceId", "NON_CLUSTERED");
            props.put("org.quartz.scheduler.makeSchedulerThreadDaemon", "true");
            props.put("org.quartz.scheduler.skipUpdateCheck", "true");
            props.put("org.quartz.threadPool.class", "org.quartz.simpl.SimpleThreadPool");
            props.put("org.quartz.threadPool.threadCount", "1");
            props.put("org.quartz.threadPool.threadPriority", "4");
            props.put("org.quartz.threadPool.makeThreadsDaemons", "true");
            schedulerFactory.initialize(props);
        }
        this.scheduler = schedulerFactory.getScheduler();
        this.scheduler.start();
        for (String job : jobs = this.scheduler.getJobNames("nuxeo")) {
            this.unschedule(job);
        }
        for (Schedule each : this.registry.getSchedules()) {
            this.registerSchedule(each);
        }
        log.info((Object)"scheduler started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownScheduler() {
        if (this.scheduler == null) {
            return;
        }
        try {
            this.scheduler.shutdown();
        }
        catch (SchedulerException cause) {
            log.error((Object)"Cannot shutdown scheduler", (Throwable)cause);
        }
        finally {
            this.scheduler = null;
        }
    }

    public void deactivate(ComponentContext context) {
        log.debug((Object)"Deactivate");
        this.shutdownScheduler();
    }

    public void applicationStarted(ComponentContext context) {
        Framework.addListener((RuntimeServiceListener)this);
        try {
            this.setupScheduler(context);
        }
        catch (IOException | SchedulerException e) {
            throw new NuxeoException(e);
        }
    }

    @Override
    public boolean hasApplicationStarted() {
        return this.scheduler != null;
    }

    public void registerExtension(Extension extension) {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            this.registerSchedule((Schedule)contrib);
        }
    }

    public void unregisterExtension(Extension extension) {
    }

    public RuntimeContext getContext() {
        return this.bundle;
    }

    @Override
    public void registerSchedule(Schedule schedule) {
        this.registerSchedule(schedule, null);
    }

    @Override
    public void registerSchedule(Schedule schedule, Map<String, Serializable> parameters) {
        this.registry.addContribution(schedule);
        if (this.scheduler == null) {
            return;
        }
        Schedule contributed = this.registry.getSchedule(schedule);
        if (contributed != null) {
            this.schedule(contributed, parameters);
        } else {
            this.unschedule(schedule.getId());
        }
    }

    protected void schedule(Schedule schedule, Map<String, Serializable> parameters) {
        CronTrigger trigger;
        log.info((Object)("Registering " + schedule));
        JobDetail job = new JobDetail(schedule.getId(), "nuxeo", EventJob.class);
        JobDataMap map = job.getJobDataMap();
        map.put("eventId", schedule.getEventId());
        map.put("eventCategory", schedule.getEventCategory());
        map.put("username", schedule.getUsername());
        if (parameters != null) {
            map.putAll(parameters);
        }
        try {
            trigger = new CronTrigger(schedule.getId(), "nuxeo", schedule.getCronExpression());
        }
        catch (ParseException e) {
            log.error((Object)String.format("invalid cron expresion '%s' for schedule '%s'", schedule.getCronExpression(), schedule.getId()), (Throwable)e);
            return;
        }
        try {
            this.scheduler.scheduleJob(job, (Trigger)trigger);
        }
        catch (ObjectAlreadyExistsException e) {
            log.trace((Object)("Overriding scheduler with id: " + schedule.getId()));
            boolean unregistred = this.unregisterSchedule(schedule.getId());
            if (unregistred) {
                try {
                    this.scheduler.scheduleJob(job, (Trigger)trigger);
                }
                catch (SchedulerException e1) {
                    log.error((Object)String.format("failed to schedule job with id '%s': %s", schedule.getId(), e.getMessage()), (Throwable)e);
                }
            }
        }
        catch (SchedulerException e) {
            log.error((Object)String.format("failed to schedule job with id '%s': %s", schedule.getId(), e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public boolean unregisterSchedule(String id) {
        log.info((Object)("Unregistering schedule with id" + id));
        Schedule schedule = this.registry.getSchedule(id);
        if (schedule == null) {
            return false;
        }
        this.registry.removeContribution(schedule, true);
        return this.unschedule(id);
    }

    protected boolean unschedule(String jobId) {
        try {
            return this.scheduler.deleteJob(jobId, "nuxeo");
        }
        catch (SchedulerException e) {
            log.error((Object)String.format("failed to unschedule job with '%s': %s", jobId, e.getMessage()), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean unregisterSchedule(Schedule schedule) {
        return this.unregisterSchedule(schedule.getId());
    }

    public void handleEvent(RuntimeServiceEvent event) {
        if (event.id != 2) {
            return;
        }
        Framework.removeListener((RuntimeServiceListener)this);
        this.shutdownScheduler();
    }
}

