/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public abstract class NuxeoBlockingQueue
extends AbstractQueue<Runnable>
implements BlockingQueue<Runnable> {
    protected final ReentrantLock activationLock = new ReentrantLock();
    protected final Condition activation = this.activationLock.newCondition();
    protected volatile boolean active = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(boolean active) {
        this.active = active;
        this.activationLock.lock();
        try {
            this.activation.signalAll();
        }
        finally {
            this.activationLock.unlock();
        }
    }

    @Override
    public boolean offer(Runnable r) {
        try {
            this.put(r);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("interrupted", e);
        }
        return true;
    }

    @Override
    public boolean offer(Runnable r, long timeout, TimeUnit unit) throws InterruptedException {
        this.put(r);
        return true;
    }

    @Override
    public void put(Runnable r) throws InterruptedException {
        this.putElement(r);
    }

    @Override
    public Runnable peek() {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public Runnable poll() {
        if (!this.active) {
            return null;
        }
        return this.pollElement();
    }

    protected long timeUntil(long end) {
        long timeout = end - System.currentTimeMillis();
        if (timeout < 0L) {
            timeout = 0L;
        }
        return timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long awaitActivation(long nanos) throws InterruptedException {
        this.activationLock.lock();
        try {
            while (nanos > 0L && !this.active) {
                nanos = this.activation.awaitNanos(nanos);
            }
        }
        finally {
            this.activationLock.unlock();
        }
        return nanos;
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.getQueueSize();
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Iterator<Runnable> iterator() {
        return new Iter();
    }

    @Override
    public int drainTo(Collection<? super Runnable> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    @Override
    public int drainTo(Collection<? super Runnable> c, int maxElements) {
        for (int i = 0; i < maxElements; ++i) {
            Runnable r = this.poll();
            if (r == null) {
                return i;
            }
            c.add(r);
        }
        return maxElements;
    }

    public abstract int getQueueSize();

    public abstract void putElement(Runnable var1) throws InterruptedException;

    public abstract Runnable pollElement();

    private class Iter
    implements Iterator<Runnable> {
        public Iter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Runnable next() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

