/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.loader;

import groovy.lang.GroovyClassLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.classgen.Verifier;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.loader.ClassProxy;

public class GroovyClassProxy
implements ClassProxy {
    private static final Log log = LogFactory.getLog(GroovyClassLoader.class);
    protected final GroovyClassLoader loader;
    protected final String className;
    protected long timestamp = 0L;

    public GroovyClassProxy(GroovyClassLoader loader, String className) {
        this.loader = loader;
        this.className = className;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public Class<?> get() {
        try {
            Class clazz = this.loader.loadClass(this.className, true, false);
            long tm = Verifier.getTimestamp((Class)clazz);
            if (this.timestamp > 0L && this.timestamp < tm && log.isDebugEnabled()) {
                log.debug((Object)("CLASS CHANGED: " + clazz.getName()));
            }
            this.timestamp = tm;
            return clazz;
        }
        catch (ReflectiveOperationException e) {
            throw WebException.wrap(e);
        }
    }

    public String toString() {
        return this.className;
    }
}

