/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.DirectoryFactory;
import org.nuxeo.ecm.directory.DirectoryServiceImpl;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.sql.SQLDirectoryDescriptor;
import org.nuxeo.ecm.directory.sql.SQLDirectoryRegistry;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;

public class SQLDirectoryFactory
extends DefaultComponent
implements DirectoryFactory {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.directory.sql.SQLDirectoryFactory");
    private static final Log log = LogFactory.getLog(SQLDirectoryFactory.class);
    protected SQLDirectoryRegistry directories;

    public Directory getDirectory(String name) throws DirectoryException {
        return this.directories.getDirectory(name);
    }

    public String getName() {
        return NAME.getName();
    }

    public void activate(ComponentContext context) {
        this.directories = new SQLDirectoryRegistry();
    }

    public void deactivate(ComponentContext context) {
        try {
            this.shutdown();
        }
        catch (DirectoryException e) {
            log.error((Object)"Error shutting down sql directories", (Throwable)e);
        }
        this.directories = null;
    }

    protected static DirectoryServiceImpl getDirectoryService() {
        return (DirectoryServiceImpl)Framework.getRuntime().getComponent(DirectoryService.NAME);
    }

    public void registerExtension(Extension extension) {
        Object[] contribs = extension.getContributions();
        DirectoryServiceImpl dirService = SQLDirectoryFactory.getDirectoryService();
        for (Object contrib : contribs) {
            SQLDirectoryDescriptor descriptor = (SQLDirectoryDescriptor)contrib;
            this.directories.addContribution(descriptor);
            String name = descriptor.getName();
            if (this.directories.getDirectory(name) != null) {
                dirService.registerDirectory(name, (DirectoryFactory)this);
                continue;
            }
            dirService.unregisterDirectory(name, (DirectoryFactory)this);
        }
    }

    public void unregisterExtension(Extension extension) {
        Object[] contribs = extension.getContributions();
        DirectoryServiceImpl dirService = SQLDirectoryFactory.getDirectoryService();
        for (Object contrib : contribs) {
            SQLDirectoryDescriptor descriptor = (SQLDirectoryDescriptor)contrib;
            this.directories.removeContribution(descriptor);
            dirService.unregisterDirectory(descriptor.getName(), (DirectoryFactory)this);
        }
    }

    public void shutdown() throws DirectoryException {
        for (Directory directory : this.directories.getDirectories()) {
            directory.shutdown();
        }
    }

    public List<Directory> getDirectories() throws DirectoryException {
        return new ArrayList<Directory>(this.directories.getDirectories());
    }
}

