/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs.login;

import java.io.IOException;
import java.security.Principal;
import java.util.Set;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.nuxeo.common.utils.Base64;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.api.local.ClientLoginModule;
import org.nuxeo.ecm.webengine.jaxrs.HttpFilter;
import org.nuxeo.runtime.api.Framework;

public class AuthenticationFilter
extends HttpFilter {
    public static final String DEFAULT_SECURITY_DOMAIN = "nuxeo-client-login";
    protected String domain = "nuxeo-client-login";
    protected boolean autoPrompt = true;
    protected String realmName = "Nuxeo";

    public void init(FilterConfig filterConfig) throws ServletException {
        String v = filterConfig.getInitParameter("securityDomain");
        if (v != null) {
            this.domain = v;
        }
        if ((v = filterConfig.getInitParameter("realmName")) != null) {
            this.realmName = v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        LoginContext lc = null;
        if (request.getUserPrincipal() == null) {
            try {
                lc = this.doLogin(request, response);
                request = this.wrapRequest(request, lc);
            }
            catch (LoginException e) {
                this.handleLoginFailure(request, response, e);
                return;
            }
        }
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            ClientLoginModule.getThreadLocalLogin().clear();
            if (lc != null) {
                try {
                    lc.logout();
                }
                catch (LoginException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public void destroy() {
    }

    protected String[] retrieveBasicLogin(HttpServletRequest httpRequest) {
        String auth = httpRequest.getHeader("authorization");
        if (auth != null && auth.toLowerCase().startsWith("basic")) {
            int idx = auth.indexOf(32);
            String b64userpassword = auth.substring(idx + 1);
            byte[] clearUp = Base64.decode((String)b64userpassword);
            String userpassword = new String(clearUp);
            String[] up = StringUtils.split((String)userpassword, (char)':', (boolean)false);
            if (up.length != 2) {
                return null;
            }
            return up;
        }
        return null;
    }

    protected LoginContext doLogin(HttpServletRequest request, HttpServletResponse response) throws LoginException {
        String[] login = this.retrieveBasicLogin(request);
        if (login != null) {
            return Framework.login((String)login[0], (Object)login[1]);
        }
        throw new LoginException("User must login");
    }

    protected void handleLoginFailure(HttpServletRequest request, HttpServletResponse response, LoginException e) {
        String s = "Basic realm=\"" + this.realmName + "\"";
        response.setHeader("WWW-Authenticate", s);
        response.setStatus(401);
    }

    protected HttpServletRequest wrapRequest(HttpServletRequest request, LoginContext lc) {
        Set<Principal> set = lc.getSubject().getPrincipals();
        if (!set.isEmpty()) {
            final Principal principal = set.iterator().next();
            return new HttpServletRequestWrapper(request){

                public Principal getUserPrincipal() {
                    return principal;
                }
            };
        }
        return request;
    }
}

