/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs.session;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.webengine.jaxrs.session.SessionRef;

public abstract class CoreSessionProvider<REF extends SessionRef> {
    private static final Log log = LogFactory.getLog(CoreSessionProvider.class);
    protected Map<String, REF> sessions = new HashMap<String, REF>();

    protected CoreSessionProvider() {
    }

    protected abstract void onRequestDone(HttpServletRequest var1);

    protected abstract REF createSessionRef(CoreSession var1);

    public SessionRef[] getSessions() {
        return this.sessions.values().toArray(new SessionRef[this.sessions.size()]);
    }

    public SessionRef getSessionRef(HttpServletRequest request, String repoName) {
        SessionRef ref = (SessionRef)this.sessions.get(repoName);
        if (ref == null) {
            ref = this.createSessionRef(this.createSession(request, repoName));
            this.sessions.put(repoName, ref);
        }
        return ref;
    }

    public CoreSession getSession(HttpServletRequest request, String repoName) {
        return this.getSessionRef(request, repoName).get();
    }

    protected CoreSession createSession(HttpServletRequest request, String repoName) {
        try {
            return this._createSession(request, repoName);
        }
        catch (ClientException e) {
            throw new WebApplicationException((Throwable)e, 500);
        }
    }

    protected CoreSession _createSession(HttpServletRequest request, String repoName) throws ClientException {
        if (request.getUserPrincipal() == null) {
            throw new IllegalStateException("Not authenticated user is trying to get a core session");
        }
        return CoreInstance.openCoreSession((String)repoName);
    }

    public boolean hasSessions() {
        return !this.sessions.isEmpty();
    }

    protected void destroy() {
        for (SessionRef ref : this.getSessions()) {
            try {
                ref.destroy();
            }
            catch (Throwable t) {
                log.error((Object)"Failed to destroy core session", t);
            }
        }
        this.sessions = null;
    }
}

