/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.relations.api.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.QNameResource;
import org.nuxeo.ecm.platform.relations.api.RelationManager;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.Statement;
import org.nuxeo.ecm.platform.relations.api.impl.LiteralImpl;
import org.nuxeo.ecm.platform.relations.api.impl.StatementImpl;
import org.nuxeo.runtime.api.Framework;

public class RelationHelper {
    static RelationManager relationManager;
    private static final Log log;

    private RelationHelper() {
    }

    public static RelationManager getRelationManager() {
        return (RelationManager)Framework.getService(RelationManager.class);
    }

    public static QNameResource getDocumentResource(DocumentModel document) throws ClientException {
        QNameResource documentResource = null;
        RelationManager rm = RelationHelper.getRelationManager();
        if (document != null && rm != null) {
            documentResource = (QNameResource)rm.getResource("http://www.nuxeo.org/document/uid/", (Serializable)document, null);
        }
        return documentResource;
    }

    public static DocumentModel getDocumentModel(Node node, CoreSession session) throws ClientException {
        if (node.isQNameResource()) {
            QNameResource resource = (QNameResource)node;
            Map<String, CoreSession> context = Collections.singletonMap("CoreSession", session);
            Serializable o = RelationHelper.getRelationManager().getResourceRepresentation(resource.getNamespace(), resource, context);
            if (o instanceof DocumentModel) {
                return (DocumentModel)o;
            }
        }
        return null;
    }

    public static DocumentModelList getSubjectDocuments(Resource predicat, String stringObject, CoreSession session) {
        return RelationHelper.getSubjectDocuments("default", predicat, stringObject, session);
    }

    public static DocumentModelList getSubjectDocuments(String graphName, Resource predicat, String stringObject, CoreSession session) {
        try {
            LiteralImpl literal = new LiteralImpl(stringObject);
            List<Statement> stmts = RelationHelper.getRelationManager().getGraphByName(graphName).getStatements(null, predicat, literal);
            if (stmts != null) {
                DocumentModelListImpl docs = new DocumentModelListImpl();
                for (Statement stmt : stmts) {
                    DocumentModel d = RelationHelper.getDocumentModel(stmt.getSubject(), session);
                    if (d == null) continue;
                    docs.add((Object)d);
                }
                return docs;
            }
        }
        catch (ClientException e) {
            log.error((Object)e, (Throwable)e);
        }
        return null;
    }

    public static DocumentModelList getSubjectDocuments(Resource predicat, DocumentModel objectDocument) {
        return RelationHelper.getSubjectDocuments("default", predicat, objectDocument);
    }

    public static DocumentModelList getSubjectDocuments(String graphName, Resource predicat, DocumentModel objectDocument) {
        try {
            QNameResource docResource = RelationHelper.getDocumentResource(objectDocument);
            List<Statement> stmts = RelationHelper.getRelationManager().getGraphByName(graphName).getStatements(null, predicat, docResource);
            if (stmts != null) {
                DocumentModelListImpl docs = new DocumentModelListImpl();
                for (Statement stmt : stmts) {
                    DocumentModel d = RelationHelper.getDocumentModel(stmt.getSubject(), objectDocument.getCoreSession());
                    if (d == null) continue;
                    docs.add((Object)d);
                }
                return docs;
            }
        }
        catch (ClientException e) {
            log.error((Object)e, (Throwable)e);
        }
        return null;
    }

    public static DocumentModelList getSubjectDocumentsOut(Resource predicat, DocumentModel objectDocument) {
        return RelationHelper.getSubjectDocumentsOut("default", predicat, objectDocument);
    }

    public static DocumentModelList getSubjectDocumentsOut(String graphName, Resource predicat, DocumentModel objectDocument) {
        try {
            QNameResource docResource = RelationHelper.getDocumentResource(objectDocument);
            List<Statement> stmts = RelationHelper.getRelationManager().getGraphByName(graphName).getStatements(docResource, predicat, null);
            if (stmts != null) {
                DocumentModelListImpl docs = new DocumentModelListImpl();
                for (Statement stmt : stmts) {
                    DocumentModel d = RelationHelper.getDocumentModel(stmt.getObject(), objectDocument.getCoreSession());
                    if (d == null) continue;
                    docs.add((Object)d);
                }
                return docs;
            }
        }
        catch (ClientException e) {
            log.error((Object)e, (Throwable)e);
        }
        return null;
    }

    public static DocumentModelList getObjectDocuments(DocumentModel subjectDoc, Resource predicat) {
        return RelationHelper.getObjectDocuments("default", subjectDoc, predicat);
    }

    public static DocumentModelList getObjectDocuments(String graphName, DocumentModel subjectDoc, Resource predicat) {
        try {
            List<Statement> stmts = RelationHelper.getStatements(graphName, subjectDoc, predicat);
            if (stmts != null) {
                DocumentModelListImpl docs = new DocumentModelListImpl();
                for (Statement stmt : stmts) {
                    DocumentModel d = RelationHelper.getDocumentModel(stmt.getObject(), subjectDoc.getCoreSession());
                    if (d == null) continue;
                    docs.add((Object)d);
                }
                return docs;
            }
        }
        catch (ClientException e) {
            log.error((Object)e, (Throwable)e);
        }
        return null;
    }

    public static List<Statement> getStatements(DocumentModel subjectDoc, Resource predicat) {
        return RelationHelper.getStatements("default", subjectDoc, predicat);
    }

    public static List<Statement> getStatements(String graphName, DocumentModel subjectDoc, Resource predicat) {
        try {
            QNameResource docResource = RelationHelper.getDocumentResource(subjectDoc);
            return RelationHelper.getRelationManager().getGraphByName(graphName).getStatements(docResource, predicat, null);
        }
        catch (ClientException e) {
            log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    public static void removeRelation(DocumentModel subjectDoc, Resource predicat, DocumentModel objectDoc) {
        RelationHelper.removeRelation("default", subjectDoc, predicat, objectDoc);
    }

    public static void removeRelation(String graphName, DocumentModel subjectDoc, Resource predicat, DocumentModel objectDoc) {
        try {
            QNameResource subject = RelationHelper.getDocumentResource(subjectDoc);
            QNameResource object = RelationHelper.getDocumentResource(objectDoc);
            StatementImpl stmt = new StatementImpl(subject, predicat, object);
            RelationHelper.getRelationManager().getGraphByName(graphName).remove(stmt);
        }
        catch (ClientException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    static {
        log = LogFactory.getLog(RelationHelper.class);
    }
}

