/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.packages.dependencies;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.PackageManager;
import org.nuxeo.connect.packages.dependencies.DependencyException;
import org.nuxeo.connect.packages.dependencies.DependencyResolution;
import org.nuxeo.connect.packages.dependencies.DependencyResolver;
import org.nuxeo.connect.packages.dependencies.RecursiveDependencyResolver;
import org.nuxeo.connect.update.PackageDependency;
import org.nuxeo.connect.update.Version;

@Deprecated
public class LegacyDependencyResolver
implements DependencyResolver {
    protected PackageManager pm;
    protected static Log log = LogFactory.getLog(LegacyDependencyResolver.class);

    public LegacyDependencyResolver(PackageManager pm) {
        this.pm = pm;
    }

    @Override
    public DependencyResolution resolve(String pkgId, String targetPlatform) throws DependencyException {
        log.debug((Object)"Computing possible dependency sets");
        RecursiveDependencyResolver choices = this.computeAvailableChoices(pkgId, targetPlatform);
        log.debug((Object)"Resulting choices : ");
        log.debug((Object)choices.toString());
        log.debug((Object)("Max possibilities : " + choices.getMaxPossibilities()));
        log.debug((Object)"Sorting choices");
        choices.sort();
        log.debug((Object)"Sorted choices : ");
        log.debug((Object)choices.toString());
        DependencyResolution res = choices.tryResolve();
        if (res != null) {
            res.sort(this.pm);
            return res;
        }
        throw new DependencyException("Unable to resolve dependencies");
    }

    @Override
    public DependencyResolution resolve(List<String> pkgInstall, List<String> pkgRemove, List<String> pkgUpgrade, String targetPlatform) throws DependencyException {
        throw new UnsupportedOperationException("Legacy resolver does not support advanced resolution method");
    }

    protected RecursiveDependencyResolver computeAvailableChoices(String pkgId, String targetPlatform) throws DependencyException {
        RecursiveDependencyResolver dc = new RecursiveDependencyResolver(pkgId, this.pm, targetPlatform);
        String path = "/" + pkgId;
        this.recurseOnAvailableChoices(pkgId, targetPlatform, dc, path);
        return dc;
    }

    protected void recurseOnAvailableChoices(String pkgId, String targetPlatform, RecursiveDependencyResolver dc, String path) throws DependencyException {
        DownloadablePackage pkg = this.pm.findPackageById(pkgId);
        if (pkg == null) {
            throw new DependencyException("Unable to find package " + pkgId);
        }
        for (PackageDependency dep : pkg.getDependencies()) {
            List<Version> versions = this.pm.getAvailableVersion(dep.getName(), dep.getVersionRange(), targetPlatform);
            if (versions.size() == 0) {
                throw new DependencyException("Unable to find a compatible version for package " + dep.getName() + " (" + dep.getVersionRange().toString() + ")");
            }
            if (path.contains("/" + dep.getName() + "/")) {
                throw new DependencyException(String.format("Detected loop in dependencies: pkg=%s,dep=%s,path=%s'", pkgId, dep.getName(), path));
            }
            dc.addDep(dep.getName(), versions);
            for (Version v : versions) {
                this.recurseOnAvailableChoices(dep.getName() + "-" + v.toString(), targetPlatform, dc, path + dep.getName() + "/");
            }
        }
    }

    @Override
    public DependencyResolution resolve(List<String> pkgInstall, List<String> pkgRemove, List<String> pkgUpgrade, String targetPlatform, boolean allowSNAPSHOT, boolean doKeep) {
        throw new UnsupportedOperationException("Legacy resolver does not support advanced resolution method");
    }

    @Override
    public DependencyResolution resolve(List<String> pkgInstall, List<String> pkgRemove, List<String> pkgUpgrade, String targetPlatform, boolean allowSNAPSHOT) throws DependencyException {
        throw new UnsupportedOperationException("Legacy resolver does not support advanced resolution method");
    }
}

