/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.probes;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.ExceptionUtils;
import org.nuxeo.ecm.core.management.api.Probe;
import org.nuxeo.ecm.core.management.api.ProbeInfo;
import org.nuxeo.ecm.core.management.api.ProbeManager;
import org.nuxeo.ecm.core.management.api.ProbeStatus;
import org.nuxeo.ecm.core.management.probes.ProbeDescriptor;
import org.nuxeo.ecm.core.management.probes.ProbeInfoImpl;
import org.nuxeo.runtime.management.ManagementRuntimeException;

public class ProbeManagerImpl
implements ProbeManager {
    protected static final Log log = LogFactory.getLog(ProbeManagerImpl.class);
    protected final Map<Class<? extends Probe>, ProbeInfo> infosByTypes = new HashMap<Class<? extends Probe>, ProbeInfo>();
    protected final Map<String, ProbeInfo> infosByShortcuts = new HashMap<String, ProbeInfo>();
    protected final Map<String, Probe> probesByShortcuts = new HashMap<String, Probe>();
    protected final Set<ProbeInfo> failed = new HashSet<ProbeInfo>();
    protected final Set<ProbeInfo> succeed = new HashSet<ProbeInfo>();

    protected Set<String> doExtractProbesName(Collection<ProbeInfo> runners) {
        HashSet<String> names = new HashSet<String>();
        for (ProbeInfo runner : runners) {
            names.add(runner.getShortcutName());
        }
        return names;
    }

    @Override
    public Collection<ProbeInfo> getAllProbeInfos() {
        return Collections.unmodifiableCollection(this.infosByTypes.values());
    }

    @Override
    public Collection<ProbeInfo> getInSuccessProbeInfos() {
        return Collections.unmodifiableCollection(this.succeed);
    }

    @Override
    public Collection<ProbeInfo> getInFailureProbeInfos() {
        return Collections.unmodifiableCollection(this.failed);
    }

    @Override
    public Collection<String> getProbeNames() {
        return this.infosByShortcuts.keySet();
    }

    @Override
    public int getProbesCount() {
        return this.infosByTypes.size();
    }

    @Override
    public Collection<String> getProbesInError() {
        return this.doExtractProbesName(this.failed);
    }

    @Override
    public int getProbesInErrorCount() {
        return this.failed.size();
    }

    @Override
    public Collection<String> getProbesInSuccess() {
        return this.doExtractProbesName(this.succeed);
    }

    @Override
    public int getProbesInSuccessCount() {
        return this.succeed.size();
    }

    @Override
    public ProbeInfo getProbeInfo(Class<? extends Probe> probeClass) {
        ProbeInfo info = this.infosByTypes.get(probeClass);
        if (info == null) {
            throw new IllegalArgumentException("no probe registered for " + probeClass);
        }
        return info;
    }

    @Override
    public boolean runAllProbes() {
        this.doRun();
        return this.getProbesInErrorCount() <= 0;
    }

    @Override
    public ProbeInfo runProbe(ProbeInfo probe) {
        this.doRunProbe(probe);
        return probe;
    }

    @Override
    public ProbeInfo runProbe(String name) {
        ProbeInfo probeInfo = this.getProbeInfo(name);
        if (probeInfo == null) {
            log.warn((Object)("Probe " + name + " can not be found"));
            return null;
        }
        return this.runProbe(probeInfo);
    }

    @Override
    public ProbeInfo getProbeInfo(String name) {
        return this.infosByShortcuts.get(name);
    }

    public void registerProbe(ProbeDescriptor descriptor) {
        Probe probe;
        Class<? extends Probe> probeClass = descriptor.getProbeClass();
        try {
            probe = probeClass.newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new ManagementRuntimeException("Cannot create management probe for " + descriptor);
        }
        ProbeInfoImpl info = new ProbeInfoImpl(descriptor);
        this.infosByTypes.put(probeClass, info);
        this.infosByShortcuts.put(descriptor.getShortcut(), info);
        this.probesByShortcuts.put(descriptor.getShortcut(), probe);
    }

    public void unregisterProbe(ProbeDescriptor descriptor) {
        Class<? extends Probe> probeClass = descriptor.getProbeClass();
        this.infosByTypes.remove(probeClass);
        this.infosByShortcuts.remove(descriptor.getShortcut());
    }

    protected void doRun() {
        for (ProbeInfo probe : this.infosByTypes.values()) {
            this.doRunProbe(probe);
        }
    }

    protected static Long doGetDuration(Date fromDate, Date toDate) {
        return toDate.getTime() - fromDate.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRunProbe(ProbeInfo probe) {
        if (!probe.isEnabled()) {
            return;
        }
        boolean ok = false;
        try {
            ProbeInfoImpl probeInfoImpl = (ProbeInfoImpl)probe;
            Thread currentThread = Thread.currentThread();
            ClassLoader lastLoader = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader(ProbeInfoImpl.class.getClassLoader());
            probeInfoImpl.lastRunnedDate = new Date();
            ++probeInfoImpl.runnedCount;
            try {
                Probe runnableProbe = this.probesByShortcuts.get(probe.getShortcutName());
                probeInfoImpl.lastStatus = runnableProbe.run();
                if (probeInfoImpl.lastStatus.isSuccess()) {
                    probeInfoImpl.lastSucceedDate = probeInfoImpl.lastRunnedDate;
                    probeInfoImpl.lastSuccessStatus = probeInfoImpl.lastStatus;
                    ++probeInfoImpl.successCount;
                } else {
                    probeInfoImpl.lastFailureStatus = probeInfoImpl.lastStatus;
                    ++probeInfoImpl.failureCount;
                    probeInfoImpl.lastFailureDate = probeInfoImpl.lastRunnedDate;
                }
            }
            catch (Exception e) {
                ExceptionUtils.checkInterrupt((Exception)e);
                ++probeInfoImpl.failureCount;
                probeInfoImpl.lastFailureDate = new Date();
                probeInfoImpl.lastFailureStatus = ProbeStatus.newError(e);
            }
            finally {
                probeInfoImpl.lastDuration = ProbeManagerImpl.doGetDuration(probeInfoImpl.lastRunnedDate, new Date());
                currentThread.setContextClassLoader(lastLoader);
            }
            if (probe.isInError()) {
                this.succeed.remove(probe);
                this.failed.add(probe);
            } else {
                this.failed.remove(probe);
                this.succeed.add(probe);
            }
            ok = true;
        }
        finally {
            if (!ok) {
                this.succeed.remove(probe);
                this.failed.add(probe);
            }
        }
    }
}

