/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.statuses;

import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Base64;
import org.nuxeo.common.utils.ExceptionUtils;
import org.nuxeo.runtime.api.Framework;

public class NuxeoInstanceIdentifierHelper {
    private static final String HASH_METHOD = "MD5";
    protected static final Log log = LogFactory.getLog(NuxeoInstanceIdentifierHelper.class);
    protected static String serverInstanceName;

    public static String generateHardwareUID() throws IOException {
        String hwUID = "";
        String javaVersion = System.getProperty("java.version");
        Enumeration<NetworkInterface> ifs = NetworkInterface.getNetworkInterfaces();
        block2: while (ifs.hasMoreElements()) {
            NetworkInterface ni = ifs.nextElement();
            if (javaVersion.contains("1.6")) {
                Method[] methods;
                for (Method method : methods = ni.getClass().getMethods()) {
                    if (!method.getName().equalsIgnoreCase("getHardwareAddress")) continue;
                    try {
                        byte[] hwAddr = (byte[])method.invoke((Object)ni, new Object[0]);
                        if (hwAddr == null) continue block2;
                        hwUID = hwUID + "-" + Base64.encodeBytes((byte[])hwAddr);
                        continue block2;
                    }
                    catch (ReflectiveOperationException e) {
                        throw ExceptionUtils.runtimeException((Exception)e);
                    }
                }
                continue;
            }
            Enumeration<InetAddress> addrs = ni.getInetAddresses();
            while (addrs.hasMoreElements()) {
                hwUID = hwUID + "-" + Base64.encodeBytes((byte[])addrs.nextElement().getAddress());
            }
        }
        return hwUID;
    }

    public static String summarize(String value) throws NoSuchAlgorithmException {
        byte[] digest = MessageDigest.getInstance(HASH_METHOD).digest(value.getBytes());
        BigInteger sum = new BigInteger(digest);
        return sum.toString(16);
    }

    public static String newServerInstanceName() {
        String instancePath;
        String hwInfo;
        String osName = System.getProperty("os.name");
        try {
            hwInfo = NuxeoInstanceIdentifierHelper.generateHardwareUID();
            hwInfo = NuxeoInstanceIdentifierHelper.summarize(hwInfo);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            hwInfo = "***";
        }
        try {
            instancePath = Framework.getRuntime().getHome().toString();
            instancePath = NuxeoInstanceIdentifierHelper.summarize(instancePath);
        }
        catch (NoSuchAlgorithmException e) {
            instancePath = "***";
        }
        return osName + "-" + instancePath + "-" + hwInfo;
    }

    public static String getServerInstanceName() {
        if (serverInstanceName == null && StringUtils.isEmpty((String)(serverInstanceName = Framework.getProperty((String)"org.nuxeo.ecm.instance.administrative.id")))) {
            serverInstanceName = NuxeoInstanceIdentifierHelper.newServerInstanceName();
        }
        return serverInstanceName;
    }
}

