/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class URIUtils {
    private static final Log log = LogFactory.getLog(URIUtils.class);

    private URIUtils() {
    }

    public static String getURIQuery(Map<String, String> parameters) {
        String query = null;
        if (parameters != null) {
            try {
                ArrayList<String> items = new ArrayList<String>();
                for (Map.Entry<String, String> paramInfo : parameters.entrySet()) {
                    String key = paramInfo.getKey();
                    String value = paramInfo.getValue();
                    if (key == null) continue;
                    if (value == null) {
                        value = "";
                    }
                    items.add(String.format("%s=%s", URLEncoder.encode(key, "UTF-8"), URLEncoder.encode(value, "UTF-8")));
                }
                query = StringUtils.join(items, (String)"&");
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)"Failed to get uri query", (Throwable)e);
            }
        }
        return query;
    }

    public static String getURIPath(String uri) {
        if (uri == null) {
            return null;
        }
        String path = uri;
        int index = uri.indexOf(63);
        if (index != -1) {
            path = uri.substring(0, index);
        }
        return path;
    }

    public static Map<String, String> getRequestParameters(String uriQuery) {
        LinkedHashMap<String, String> parameters = null;
        if (uriQuery != null && uriQuery.length() > 0) {
            try {
                int index = uriQuery.indexOf(63);
                String strippedQuery = index != -1 ? uriQuery.substring(index + 1) : uriQuery;
                String[] items = strippedQuery.split("&");
                if (items != null && items.length > 0) {
                    parameters = new LinkedHashMap<String, String>();
                    for (String item : items) {
                        String[] param = item.split("=");
                        if (param == null) continue;
                        if (param.length == 2) {
                            parameters.put(URLDecoder.decode(param[0], "UTF-8"), URLDecoder.decode(param[1], "UTF-8"));
                            continue;
                        }
                        if (param.length != 1) continue;
                        parameters.put(URLDecoder.decode(param[0], "UTF-8"), null);
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)"Failed to get request parameters from uri", (Throwable)e);
            }
        }
        return parameters;
    }

    public static String addParametersToURIQuery(String uriString, Map<String, String> parameters) {
        if (uriString == null || parameters == null || parameters.isEmpty()) {
            return uriString;
        }
        String uriPath = URIUtils.getURIPath(uriString);
        Map<String, String> existingParams = URIUtils.getRequestParameters(uriString.substring(uriPath.length()));
        if (existingParams == null) {
            existingParams = new LinkedHashMap<String, String>();
        }
        existingParams.putAll(parameters);
        String res = null;
        if (!existingParams.isEmpty()) {
            String newQuery = URIUtils.getURIQuery(existingParams);
            res = uriPath + '?' + newQuery;
        } else {
            res = uriPath;
        }
        return res;
    }

    public static String quoteURIPathComponent(String s, boolean quoteSlash) {
        return URIUtils.quoteURIPathComponent(s, quoteSlash, true);
    }

    public static String quoteURIPathComponent(String s, boolean quoteSlash, boolean quoteAt) {
        URI uri;
        if ("".equals(s)) {
            return s;
        }
        try {
            uri = new URI("x", s, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Illegal characters in: " + s, e);
        }
        String r = uri.toASCIIString().substring(2);
        r = r.replace(";", "%3B");
        r = r.replace(":", "%3A");
        r = r.replace("$", "%24");
        r = r.replace("&", "%26");
        r = r.replace("+", "%2B");
        r = r.replace("=", "%3D");
        r = r.replace("?", "%3F");
        r = r.replace("[", "%5B");
        r = r.replace("]", "%5D");
        if (quoteAt) {
            r = r.replace("@", "%40");
        }
        if (quoteSlash) {
            r = r.replace("/", "%2F");
        }
        return r;
    }

    public static String unquoteURIPathComponent(String s) {
        URI uri;
        if ("".equals(s)) {
            return s;
        }
        try {
            uri = new URI("http://x/" + s);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Illegal characters in: " + s, e);
        }
        String path = uri.getPath();
        if (path.startsWith("/") && !s.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }
}

