/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.tag.operations;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.tag.TagService;

@Operation(id="Services.TagDocument", category="Services", label="Tag Document", description="Tag document with one or several 'tags'.", since="7.1", addToStudio=true)
public class TagDocument {
    public static final String ID = "Services.TagDocument";
    @Context
    protected TagService tagService;
    @Context
    protected CoreSession session;
    @Param(name="tags", required=true, description="Labels or tags separated by comma.")
    protected StringList tags;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel document) throws ClientException {
        if (this.tags != null) {
            for (String tag : this.tags) {
                this.tagService.tag(this.session, document.getId(), tag, this.session.getPrincipal().getName());
            }
        }
        return document;
    }
}

