/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.component.holder;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ui.web.component.holder.UIValueHolder;

public class NuxeoValueHolderBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "nuxeoValueHolderBean";
    private static final Log log = LogFactory.getLog(NuxeoValueHolderBean.class);
    protected Map<String, Serializable> values;

    @PostConstruct
    @PreDestroy
    public void init() {
        this.values = new HashMap<String, Serializable>();
    }

    public Map<String, Serializable> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public void saveState(UIValueHolder c, Object value) {
        String fid = c.getFaceletId();
        if (fid == null) {
            log.error((Object)"Cannot save UIValueHolder state: missing facelet marker id on component attributes");
            return;
        }
        if (value == null || value instanceof Serializable) {
            this.values.put(fid, (Serializable)value);
        } else {
            log.warn((Object)("Value is not serializable, cannot store it in view: " + value));
        }
    }

    public void saveState(UIValueHolder c) {
        this.saveState(c, c.getValueToExpose());
    }

    public Object getState(String id) {
        return this.values.get(id);
    }
}

