/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.directory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectItem;
import javax.faces.component.html.HtmlSelectOneListbox;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.ui.web.directory.ChainSelect;
import org.nuxeo.ecm.platform.ui.web.directory.ChainSelectState;
import org.nuxeo.ecm.platform.ui.web.directory.DirectoryEntry;
import org.nuxeo.ecm.platform.ui.web.directory.DirectoryHelper;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;

public abstract class ChainSelectBase
extends UIInput
implements NamingContainer {
    private static final Log log = LogFactory.getLog(ChainSelect.class);
    protected static final String DISPLAY_LABEL = "label";
    protected static final String DISPLAY_ID = "id";
    protected static final String DISPLAY_IDLABEL = "idAndLabel";
    protected static final String DEFAULT_KEYSEPARATOR = "/";
    protected static final String SELECT = "selectListbox";
    public static final String VOCABULARY_SCHEMA = "vocabulary";
    public static final String XVOCABULARY_SCHEMA = "xvocabulary";
    protected String directoryNames;
    protected String keySeparator = "/";
    protected boolean qualifiedParentKeys = false;
    protected int depth;
    protected String display = "label";
    protected boolean translate;
    protected boolean showObsolete;
    protected String style;
    protected String styleClass;
    protected int listboxSize;
    protected boolean allowBranchSelection;
    protected String reRender;
    private boolean displayValueOnly;
    protected String defaultRootKey;
    protected Map<String, String[]> selectionMap = new HashMap<String, String[]>();

    protected ChainSelectBase() {
        HtmlSelectOneListbox select = new HtmlSelectOneListbox();
        this.getFacets().put(SELECT, select);
    }

    public String getDirectory(int level) {
        String[] directories = this.getDirectories();
        if (this.isRecursive()) {
            return directories[0];
        }
        if (level < directories.length) {
            return directories[level];
        }
        return null;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        ChainSelectState chainState = (ChainSelectState)values[1];
        this.selectionMap = (Map)values[2];
        this.depth = chainState.getDepth();
        this.display = chainState.getDisplay();
        this.directoryNames = chainState.getDirectoryNames();
        this.keySeparator = chainState.getKeySeparator();
        this.qualifiedParentKeys = chainState.getQualifiedParentKeys();
        this.showObsolete = chainState.getShowObsolete();
        this.listboxSize = chainState.getListboxSize();
        this.style = chainState.getStyle();
        this.styleClass = chainState.getStyleClass();
        this.translate = chainState.getTranslate();
        this.allowBranchSelection = chainState.getAllowBranchSelection();
        this.reRender = chainState.getReRender();
        this.displayValueOnly = chainState.getDisplayValueOnly();
        this.defaultRootKey = chainState.getDefaultRootKey();
    }

    public Object saveState(FacesContext context) {
        ChainSelectState chainState = new ChainSelectState();
        chainState.setDepth(this.depth);
        chainState.setDisplay(this.display);
        chainState.setDirectoryNames(this.directoryNames);
        chainState.setKeySeparator(this.keySeparator);
        chainState.setQualifiedParentKeys(this.qualifiedParentKeys);
        chainState.setShowObsolete(this.showObsolete);
        chainState.setStyle(this.style);
        chainState.setStyleClass(this.styleClass);
        chainState.setTranslate(this.translate);
        chainState.setListboxSize(this.listboxSize);
        chainState.setAllowBranchSelection(this.allowBranchSelection);
        chainState.setReRender(this.reRender);
        chainState.setDisplayValueOnly(this.displayValueOnly);
        chainState.setDefaultRootKey(this.defaultRootKey);
        Object[] values = new Object[]{super.saveState(context), chainState, this.selectionMap};
        return values;
    }

    protected HtmlSelectOneListbox getListbox(FacesContext context, int level) {
        String componentId = this.getComponentId(level);
        HtmlSelectOneListbox listbox = new HtmlSelectOneListbox();
        this.getChildren().add(listbox);
        listbox.setId(componentId);
        listbox.getChildren().clear();
        String reRender = this.getReRender();
        if (reRender == null) {
            reRender = this.getId();
        }
        UIComponent support = context.getApplication().createComponent("org.ajax4jsf.ajax.Support");
        support.getAttributes().put("event", "onchange");
        support.getAttributes().put("reRender", reRender);
        support.getAttributes().put("immediate", Boolean.TRUE);
        support.getAttributes().put(DISPLAY_ID, componentId + "_a4jSupport");
        listbox.getChildren().add(support);
        return listbox;
    }

    protected void encodeListbox(FacesContext context, int level, String[] selectedKeys) throws IOException {
        HtmlSelectOneListbox listbox = this.getListbox(context, level);
        listbox.setSize(this.getListboxSize());
        List<Object> items = level <= selectedKeys.length ? this.getDirectoryEntries(level, selectedKeys) : new ArrayList();
        UISelectItem emptyItem = new UISelectItem();
        emptyItem.setItemLabel(ComponentUtils.translate(context, "label.vocabulary.selectValue"));
        emptyItem.setItemValue((Object)"");
        emptyItem.setId(context.getViewRoot().createUniqueId());
        listbox.getChildren().add(emptyItem);
        for (DirectoryEntry directoryEntry : items) {
            UISelectItem selectItem = new UISelectItem();
            String itemValue = directoryEntry.getId();
            String itemLabel = directoryEntry.getLabel();
            itemLabel = this.computeItemLabel(context, itemValue, itemLabel);
            selectItem.setItemValue((Object)itemValue);
            selectItem.setItemLabel(itemLabel);
            selectItem.setId(context.getViewRoot().createUniqueId());
            listbox.getChildren().add(selectItem);
        }
        if (level < selectedKeys.length) {
            listbox.setValue((Object)selectedKeys[level]);
        }
        ComponentUtils.encodeComponent(context, (UIComponent)listbox);
    }

    public String[] getDirectories() {
        return StringUtils.split((String)this.getDirectoryNames(), (String)",");
    }

    public boolean isRecursive() {
        return this.getDirectories().length != this.getDepth();
    }

    public List<DirectoryEntry> getDirectoryEntries(int level, String[] selectedKeys) {
        assert (level <= selectedKeys.length);
        ArrayList<DirectoryEntry> result = new ArrayList<DirectoryEntry>();
        String directoryName = this.getDirectory(level);
        DirectoryService service = DirectoryHelper.getDirectoryService();
        Session session = null;
        try {
            String schema = service.getDirectorySchema(directoryName);
            session = service.open(directoryName);
            HashMap<String, String> filter = new HashMap<String, String>();
            if (level == 0) {
                if (schema.equals(XVOCABULARY_SCHEMA)) {
                    filter.put("parent", null);
                }
            } else if (this.getQualifiedParentKeys()) {
                Iterator<String> iter = Arrays.asList(selectedKeys).subList(0, level).iterator();
                String fullPath = StringUtils.join(iter, (String)this.getKeySeparator());
                filter.put("parent", fullPath);
            } else {
                filter.put("parent", selectedKeys[level - 1]);
            }
            if (!this.getShowObsolete()) {
                filter.put("obsolete", "0");
            }
            Set emptySet = Collections.emptySet();
            LinkedHashMap<String, String> orderBy = new LinkedHashMap<String, String>();
            if (schema.equals(VOCABULARY_SCHEMA) || schema.equals(XVOCABULARY_SCHEMA)) {
                orderBy.put("ordering", "asc");
                orderBy.put(DISPLAY_ID, "asc");
            }
            DocumentModelList entries = session.query(filter, emptySet, orderBy);
            for (DocumentModel entry : entries) {
                DirectoryEntry newNode = new DirectoryEntry(schema, entry);
                result.add(newNode);
            }
        }
        catch (ClientException e) {
            try {
                throw new RuntimeException("failed to query  directory: " + directoryName, e);
            }
            catch (Throwable throwable) {
                ChainSelectBase.closeSession(session);
                throw throwable;
            }
        }
        ChainSelectBase.closeSession(session);
        return result;
    }

    public List<DirectoryEntry> resolveKeys(String[] keys) {
        ArrayList<DirectoryEntry> result = new ArrayList<DirectoryEntry>();
        DirectoryService service = DirectoryHelper.getDirectoryService();
        Session session = null;
        for (int level = 0; level < keys.length; ++level) {
            DocumentModelList entries;
            String schema;
            block11: {
                String directoryName = this.getDirectory(level);
                schema = service.getDirectorySchema(directoryName);
                session = service.open(directoryName);
                HashMap<String, String> filter = new HashMap<String, String>();
                if (level == 0) {
                    if (schema.equals(XVOCABULARY_SCHEMA)) {
                        filter.put("parent", null);
                    }
                } else if (this.getQualifiedParentKeys()) {
                    Iterator<String> iter = Arrays.asList(keys).subList(0, level).iterator();
                    String fullPath = StringUtils.join(iter, (String)this.getKeySeparator());
                    filter.put("parent", fullPath);
                } else {
                    filter.put("parent", keys[level - 1]);
                }
                filter.put(DISPLAY_ID, keys[level]);
                entries = session.query(filter);
                if (entries != null && !entries.isEmpty()) break block11;
                log.warn((Object)("keyList could not be resolved at level " + level));
                ChainSelectBase.closeSession(session);
                break;
            }
            try {
                DirectoryEntry node = new DirectoryEntry(schema, (DocumentModel)entries.get(0));
                result.add(node);
            }
            catch (ClientException e) {
                try {
                    throw new RuntimeException("failed to lookup keys: ", e);
                }
                catch (Throwable throwable) {
                    ChainSelectBase.closeSession(session);
                    throw throwable;
                }
            }
            ChainSelectBase.closeSession(session);
        }
        return result;
    }

    private static void closeSession(Session session) {
        try {
            session.close();
        }
        catch (DirectoryException directoryException) {
            // empty catch block
        }
    }

    public String getComponentId(int level) {
        String directory = this.getDirectory(level);
        if (this.isRecursive()) {
            return directory + '_' + level;
        }
        return directory + '_' + level;
    }

    public String getKeySeparator() {
        ValueExpression ve = this.getValueExpression("keySeparator");
        if (ve != null) {
            return (String)ve.getValue(FacesContext.getCurrentInstance().getELContext());
        }
        return this.keySeparator;
    }

    public void setKeySeparator(String keySeparator) {
        this.keySeparator = keySeparator;
    }

    public String getDefaultRootKey() {
        ValueExpression ve = this.getValueExpression("defaultRootKey");
        if (ve != null) {
            return (String)ve.getValue(FacesContext.getCurrentInstance().getELContext());
        }
        return this.defaultRootKey;
    }

    public void setDefaultRootKey(String defaultRootKey) {
        this.defaultRootKey = defaultRootKey;
    }

    public boolean getDisplayValueOnly() {
        ValueExpression ve = this.getValueExpression("displayValueOnly");
        if (ve != null) {
            Boolean value = (Boolean)ve.getValue(FacesContext.getCurrentInstance().getELContext());
            return value == null ? false : value;
        }
        return this.displayValueOnly;
    }

    public void setDisplayValueOnly(boolean displayValueOnly) {
        this.displayValueOnly = displayValueOnly;
    }

    public int getListboxSize() {
        ValueExpression ve = this.getValueExpression("listboxSize");
        if (ve != null) {
            return (Integer)ve.getValue(FacesContext.getCurrentInstance().getELContext());
        }
        return this.listboxSize;
    }

    public void setListboxSize(int listboxSize) {
        this.listboxSize = listboxSize;
    }

    public String getDisplay() {
        ValueExpression ve = this.getValueExpression("display");
        if (ve != null) {
            return (String)ve.getValue(FacesContext.getCurrentInstance().getELContext());
        }
        return this.display != null ? this.display : DISPLAY_LABEL;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public boolean getQualifiedParentKeys() {
        ValueExpression ve = this.getValueExpression("qualifiedParentKeys");
        if (ve != null) {
            return (Boolean)ve.getValue(FacesContext.getCurrentInstance().getELContext());
        }
        return this.qualifiedParentKeys;
    }

    public String getDirectoryNames() {
        ValueExpression ve = this.getValueExpression("directoryNames");
        if (ve != null) {
            return (String)ve.getValue(FacesContext.getCurrentInstance().getELContext());
        }
        return this.directoryNames;
    }

    public void setDirectoryNames(String directoryNames) {
        this.directoryNames = directoryNames;
    }

    public int getDepth() {
        ValueExpression ve = this.getValueExpression("depth");
        int myDepth = ve != null ? (Integer)ve.getValue(FacesContext.getCurrentInstance().getELContext()) : this.depth;
        return myDepth != 0 ? myDepth : this.getDirectories().length;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public String getStyle() {
        ValueExpression ve = this.getValueExpression("style");
        if (ve != null) {
            return (String)ve.getValue(FacesContext.getCurrentInstance().getELContext());
        }
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyleClass() {
        ValueExpression ve = this.getValueExpression("styleClass");
        if (ve != null) {
            return (String)ve.getValue(FacesContext.getCurrentInstance().getELContext());
        }
        return this.styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public boolean getTranslate() {
        ValueExpression ve_translate = this.getValueExpression("translate");
        if (ve_translate != null) {
            return (Boolean)ve_translate.getValue(FacesContext.getCurrentInstance().getELContext());
        }
        return this.translate;
    }

    public void setTranslate(boolean translate) {
        this.translate = translate;
    }

    public boolean getShowObsolete() {
        ValueExpression ve = this.getValueExpression("showObsolete");
        if (ve != null) {
            return (Boolean)ve.getValue(FacesContext.getCurrentInstance().getELContext());
        }
        return this.showObsolete;
    }

    public void setShowObsolete(boolean showObsolete) {
        this.showObsolete = showObsolete;
    }

    public boolean getAllowBranchSelection() {
        ValueExpression ve = this.getValueExpression("allowBranchSelection");
        if (ve != null) {
            return (Boolean)ve.getValue(FacesContext.getCurrentInstance().getELContext());
        }
        return this.allowBranchSelection;
    }

    public void setAllowBranchSelection(boolean allowBranchSelection) {
        this.allowBranchSelection = allowBranchSelection;
    }

    public String getReRender() {
        ValueExpression ve = this.getValueExpression("reRender");
        if (ve != null) {
            return (String)ve.getValue(FacesContext.getCurrentInstance().getELContext());
        }
        return this.reRender;
    }

    public void setReRender(String reRender) {
        this.reRender = reRender;
    }

    protected String[] getValueAsArray(String value) {
        if (value == null) {
            return new String[0];
        }
        return StringUtils.split((String)value, (String)this.getKeySeparator());
    }

    protected String getValueAsString(String[] ar) {
        return StringUtils.join((Object[])ar, (String)this.getKeySeparator());
    }

    protected String computeItemLabel(FacesContext context, String id, String label) {
        boolean translate = this.getTranslate();
        String display = this.getDisplay();
        String translatedLabel = label;
        if (translate) {
            translatedLabel = ComponentUtils.translate(context, label);
        }
        if (DISPLAY_ID.equals(display)) {
            return id;
        }
        if (DISPLAY_LABEL.equals(display)) {
            return translatedLabel;
        }
        if (DISPLAY_IDLABEL.equals(display)) {
            return id + ' ' + translatedLabel;
        }
        throw new RuntimeException("invalid value for attribute 'display'; should be either 'id', 'label' or 'idAndLabel'");
    }

    public abstract String[] getSelection();

    protected void decodeSelection(FacesContext context) {
        String clientId;
        String value;
        ArrayList<String> selectedKeyList = new ArrayList<String>();
        Map parameters = context.getExternalContext().getRequestParameterMap();
        String[] selection = this.getSelection();
        for (int level = 0; level < this.getDepth() && !StringUtils.isEmpty((String)(value = (String)parameters.get(clientId = this.getClientId(context) + ':' + this.getComponentId(level)))); ++level) {
            String oldValue;
            selectedKeyList.add(value);
            if (level >= selection.length || !value.equals(oldValue = selection[level])) break;
        }
        selection = selectedKeyList.toArray(new String[selectedKeyList.size()]);
        this.setSelection(selection);
    }

    protected void setSelection(String[] selection) {
        String clientId = this.getClientId(FacesContext.getCurrentInstance());
        this.selectionMap.put(clientId, selection);
    }

    protected boolean validateEntry(FacesContext context, String[] keys) {
        if (!this.getAllowBranchSelection() && keys.length != this.getDepth()) {
            String messageStr = ComponentUtils.translate(context, "label.chainSelect.incomplete_selection");
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, messageStr, messageStr);
            context.addMessage(this.getClientId(context), message);
            this.setValid(false);
            return false;
        }
        return true;
    }
}

