/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.directory;

import java.io.IOException;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.platform.ui.web.directory.DirectoryEntryOutputComponent;
import org.nuxeo.ecm.platform.ui.web.directory.DirectoryHelper;

public class DirectoryEntryOutputRenderer
extends Renderer {
    private static final Log log = LogFactory.getLog(DirectoryHelper.class);

    public void encodeBegin(FacesContext context, UIComponent component) {
        DirectoryEntryOutputComponent dirComponent = (DirectoryEntryOutputComponent)component;
        String entryId = (String)dirComponent.getValue();
        if (entryId == null) {
            entryId = dirComponent.getEntryId();
        }
        String directoryName = dirComponent.getDirectoryName();
        String toWrite = null;
        if (directoryName != null) {
            DocumentModel entry;
            String schema;
            String keySeparator = (String)dirComponent.getAttributes().get("keySeparator");
            try {
                schema = DirectoryHelper.getDirectoryService().getDirectorySchema(directoryName);
            }
            catch (DirectoryException de) {
                log.error((Object)("Unable to get directory schema for " + directoryName), (Throwable)de);
                String string = schema = keySeparator != null ? "xvocabulary" : "vocabulary";
            }
            if (keySeparator != null && entryId != null) {
                entryId = entryId.substring(entryId.lastIndexOf(keySeparator) + 1, entryId.length());
            }
            if ((entry = DirectoryHelper.getEntry(directoryName, entryId)) != null) {
                String label;
                Boolean displayIdAndLabel = dirComponent.getDisplayIdAndLabel();
                if (displayIdAndLabel == null) {
                    displayIdAndLabel = Boolean.FALSE;
                }
                Boolean translate = dirComponent.getLocalize();
                try {
                    label = (String)entry.getProperty(schema, "label");
                }
                catch (ClientException e) {
                    label = null;
                }
                String display = (String)dirComponent.getAttributes().get("display");
                if (label == null || "".equals(label)) {
                    label = entryId;
                }
                if (Boolean.TRUE.equals(translate)) {
                    label = DirectoryEntryOutputRenderer.translate(context, label);
                }
                toWrite = DirectoryHelper.getOptionValue(entryId, label, display, displayIdAndLabel, " ");
            }
        }
        if (toWrite == null) {
            toWrite = entryId;
        }
        try {
            if (toWrite != null) {
                ResponseWriter writer = context.getResponseWriter();
                writer.writeText((Object)toWrite, null);
                writer.flush();
            }
        }
        catch (IOException e) {
            log.error((Object)"IOException trying to write on the response", (Throwable)e);
        }
    }

    protected static String translate(FacesContext context, String label) {
        String bundleName = context.getApplication().getMessageBundle();
        Locale locale = context.getViewRoot().getLocale();
        label = I18NUtils.getMessageString((String)bundleName, (String)label, null, (Locale)locale);
        return label;
    }
}

