/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.rest;

import java.io.IOException;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.transaction.Transaction;
import org.nuxeo.common.utils.ExceptionUtils;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.platform.ui.web.rest.api.URLPolicyService;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.NuxeoExceptionHandler;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.service.ExceptionHandlingService;
import org.nuxeo.runtime.api.Framework;

public class RestfulPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(RestfulPhaseListener.class);
    public static final String SEAM_HOTRELOAD_TRIGGER_ACTION = "#{seamReloadContext.triggerReloadIdNeeded()}";
    protected URLPolicyService service;

    protected URLPolicyService getURLPolicyService() {
        if (this.service == null) {
            this.service = (URLPolicyService)Framework.getService(URLPolicyService.class);
        }
        return this.service;
    }

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }

    public void beforePhase(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        HttpServletRequest httpRequest = (HttpServletRequest)context.getExternalContext().getRequest();
        try {
            URLPolicyService service = this.getURLPolicyService();
            if (service.isCandidateForDecoding(httpRequest)) {
                if (!Transaction.instance().isActiveOrMarkedRollback()) {
                    Transaction.instance().begin();
                }
                this.resetHotReloadContext(context);
                service.navigate(context);
                service.applyRequestParameters(context);
            }
        }
        catch (Exception e) {
            ExceptionUtils.checkInterrupt((Exception)e);
            this.handleException(context, e);
        }
    }

    public void afterPhase(PhaseEvent event) {
    }

    protected void handleException(FacesContext context, Exception e) throws ClientRuntimeException {
        try {
            ExternalContext externalContext = context.getExternalContext();
            ExceptionHandlingService exceptionHandlingService = (ExceptionHandlingService)Framework.getService(ExceptionHandlingService.class);
            NuxeoExceptionHandler handler = exceptionHandlingService.getExceptionHandler();
            handler.handleException((HttpServletRequest)externalContext.getRequest(), (HttpServletResponse)externalContext.getResponse(), (Throwable)e);
        }
        catch (ServletException e1) {
            throw new ClientRuntimeException((Throwable)e1);
        }
        catch (IOException e1) {
            throw new ClientRuntimeException((Throwable)e1);
        }
    }

    protected void resetHotReloadContext(FacesContext facesContext) {
        if (Framework.isDevModeSet()) {
            try {
                ExpressionFactory ef = facesContext.getApplication().getExpressionFactory();
                ELContext context = facesContext.getELContext();
                String actionBinding = SEAM_HOTRELOAD_TRIGGER_ACTION;
                MethodExpression action = ef.createMethodExpression(context, actionBinding, String.class, new Class[]{DocumentView.class});
                action.invoke(context, new Object[0]);
            }
            catch (NullPointerException | ELException e) {
                String msg = String.format("Error while trying to flush seam context after a reload, executing method expression '%s'", SEAM_HOTRELOAD_TRIGGER_ACTION);
                log.error((Object)msg, e);
            }
        }
    }
}

