/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.providers;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.oauth2.providers.NuxeoOAuth2ServiceProvider;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProviderRegistry;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class OAuth2ServiceProviderRegistryImpl
extends DefaultComponent
implements OAuth2ServiceProviderRegistry {
    protected static final Log log = LogFactory.getLog(OAuth2ServiceProviderRegistryImpl.class);
    public static final String DIRECTORY_NAME = "oauth2ServiceProviders";

    @Override
    public NuxeoOAuth2ServiceProvider getProvider(String serviceName) {
        try {
            NuxeoOAuth2ServiceProvider provider = this.getEntry(serviceName, null);
            return provider;
        }
        catch (ClientException e) {
            log.error((Object)"Unable to read provider from Directory backend", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NuxeoOAuth2ServiceProvider addProvider(String serviceName, String tokenServerURL, String authorizationServerURL, String clientId, String clientSecret, List<String> scopes) {
        NuxeoOAuth2ServiceProvider provider = new NuxeoOAuth2ServiceProvider(null, serviceName, tokenServerURL, authorizationServerURL, clientId, clientSecret, scopes);
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        try (Session session = null;){
            session = ds.open(DIRECTORY_NAME);
            DocumentModel creationEntry = BaseSession.createEntryModel(null, (String)"oauth2ServiceProvider", null, null);
            DocumentModel entry = session.createEntry(creationEntry);
            provider.asDocumentModel(entry);
            session.updateEntry(entry);
            NuxeoOAuth2ServiceProvider nuxeoOAuth2ServiceProvider = this.getProvider(serviceName);
            return nuxeoOAuth2ServiceProvider;
        }
    }

    protected String preProcessServiceName(String serviceName) {
        if (serviceName != null && serviceName.trim().isEmpty()) {
            return null;
        }
        return serviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NuxeoOAuth2ServiceProvider getEntry(String serviceName, Set<String> ftFilter) throws ClientException {
        if ((serviceName = this.preProcessServiceName(serviceName)) == null) {
            log.warn((Object)"Can not find provider with null serviceName !");
            return null;
        }
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        NuxeoOAuth2ServiceProvider provider = null;
        try (Session session = null;){
            DocumentModelList entries;
            session = ds.open(DIRECTORY_NAME);
            HashMap<String, String> filter = new HashMap<String, String>();
            if (serviceName != null) {
                filter.put("serviceName", serviceName);
            }
            if ((entries = session.query(filter, ftFilter)) == null || entries.size() == 0) {
                NuxeoOAuth2ServiceProvider nuxeoOAuth2ServiceProvider = null;
                return nuxeoOAuth2ServiceProvider;
            }
            if (entries.size() > 1) {
                log.warn((Object)("Found several entries for  serviceName=" + serviceName));
            }
            DocumentModel entry = (DocumentModel)entries.get(0);
            NuxeoOAuth2ServiceProvider nuxeoOAuth2ServiceProvider = provider = NuxeoOAuth2ServiceProvider.createFromDirectoryEntry(entry);
            return nuxeoOAuth2ServiceProvider;
        }
    }
}

