/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mimetype.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jmimemagic.Magic;
import net.sf.jmimemagic.MagicException;
import net.sf.jmimemagic.MagicMatch;
import net.sf.jmimemagic.MagicMatchNotFoundException;
import net.sf.jmimemagic.MagicParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.platform.mimetype.MimetypeDetectionException;
import org.nuxeo.ecm.platform.mimetype.MimetypeNotFoundException;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeEntry;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.mimetype.service.ExtensionDescriptor;
import org.nuxeo.ecm.platform.mimetype.service.MimetypeDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;
import org.nuxeo.runtime.model.RuntimeContext;

public class MimetypeRegistryService
extends DefaultComponent
implements MimetypeRegistry {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.platform.mimetype.service.MimetypeRegistryService");
    public static final long MAX_SIZE_FOR_SCAN = 0xA00000L;
    private static final Log log = LogFactory.getLog(MimetypeRegistryService.class);
    protected Map<String, MimetypeEntry> mimetypeByNormalisedRegistry;
    protected Map<String, MimetypeEntry> mimetypeByExtensionRegistry;
    protected Map<String, ExtensionDescriptor> extensionRegistry;
    private RuntimeContext bundle;

    public MimetypeRegistryService() {
        this.initializeRegistries();
    }

    protected void initializeRegistries() {
        this.mimetypeByNormalisedRegistry = new HashMap<String, MimetypeEntry>();
        this.mimetypeByExtensionRegistry = new HashMap<String, MimetypeEntry>();
        this.extensionRegistry = new HashMap<String, ExtensionDescriptor>();
    }

    protected boolean isMimetypeEntry(String mimetypeName) {
        return this.mimetypeByNormalisedRegistry.containsKey(mimetypeName);
    }

    public void activate(ComponentContext context) {
        this.bundle = context.getRuntimeContext();
        this.initializeRegistries();
    }

    public void deactivate(ComponentContext context) {
        this.mimetypeByNormalisedRegistry = null;
        this.mimetypeByExtensionRegistry = null;
        this.extensionRegistry = null;
    }

    public void registerExtension(Extension extension) {
        Object[] contribs = extension.getContributions();
        if (contribs == null) {
            return;
        }
        for (Object contrib : contribs) {
            if (contrib instanceof MimetypeDescriptor) {
                MimetypeDescriptor mimetypeDescriptor = (MimetypeDescriptor)contrib;
                this.registerMimetype(mimetypeDescriptor.getMimetype());
                continue;
            }
            if (!(contrib instanceof ExtensionDescriptor)) continue;
            this.registerFileExtension((ExtensionDescriptor)contrib);
        }
    }

    public void registerMimetype(MimetypeEntry mimetype) {
        log.debug((Object)("Registering mimetype: " + mimetype.getNormalized()));
        this.mimetypeByNormalisedRegistry.put(mimetype.getNormalized(), mimetype);
        for (String extension : mimetype.getExtensions()) {
            this.mimetypeByExtensionRegistry.put(extension, mimetype);
        }
    }

    public void registerFileExtension(ExtensionDescriptor extensionDescriptor) {
        log.debug((Object)("Registering file extension: " + extensionDescriptor.getName()));
        this.extensionRegistry.put(extensionDescriptor.getName(), extensionDescriptor);
    }

    public void unregisterExtension(Extension extension) {
        Object[] contribs = extension.getContributions();
        if (contribs == null) {
            return;
        }
        for (Object contrib : contribs) {
            if (contrib instanceof MimetypeDescriptor) {
                MimetypeDescriptor mimetypeDescriptor = (MimetypeDescriptor)contrib;
                this.unregisterMimetype(mimetypeDescriptor.getNormalized());
                continue;
            }
            if (!(contrib instanceof ExtensionDescriptor)) continue;
            ExtensionDescriptor extensionDescriptor = (ExtensionDescriptor)contrib;
            this.unregisterFileExtension(extensionDescriptor);
        }
    }

    public void unregisterMimetype(String mimetypeName) {
        log.debug((Object)("Unregistering mimetype: " + mimetypeName));
        MimetypeEntry mimetype = this.mimetypeByNormalisedRegistry.get(mimetypeName);
        if (mimetype == null) {
            return;
        }
        List<String> extensions = mimetype.getExtensions();
        this.mimetypeByNormalisedRegistry.remove(mimetypeName);
        for (String extension : extensions) {
            if (!mimetype.getNormalized().equals(this.mimetypeByExtensionRegistry.get(extension))) continue;
            this.mimetypeByExtensionRegistry.remove(extension);
        }
    }

    public void unregisterFileExtension(ExtensionDescriptor extensionDescriptor) {
        log.debug((Object)("Unregistering file extension: " + extensionDescriptor.getName()));
        this.extensionRegistry.remove(extensionDescriptor.getName());
    }

    public RuntimeContext getContext() {
        return this.bundle;
    }

    @Override
    public List<String> getExtensionsFromMimetypeName(String mimetypeName) {
        ArrayList<String> extensions = new ArrayList<String>();
        for (String key : this.mimetypeByNormalisedRegistry.keySet()) {
            MimetypeEntry mimetypeEntry = this.mimetypeByNormalisedRegistry.get(key);
            if (!mimetypeEntry.getMimetypes().contains(mimetypeName)) continue;
            extensions.addAll(mimetypeEntry.getExtensions());
        }
        return extensions;
    }

    @Override
    public MimetypeEntry getMimetypeEntryByName(String name) {
        return this.mimetypeByNormalisedRegistry.get(name);
    }

    @Override
    public String getMimetypeFromFile(File file) throws MimetypeNotFoundException, MimetypeDetectionException {
        if (file.length() > 0xA00000L) {
            String exceptionMessage = "Not able to determine mime type from filename and file is too big for binary scan.";
            if (file.getAbsolutePath() == null) {
                throw new MimetypeNotFoundException(exceptionMessage);
            }
            try {
                return this.getMimetypeFromFilename(file.getAbsolutePath());
            }
            catch (MimetypeNotFoundException e) {
                throw new MimetypeNotFoundException(exceptionMessage, (Throwable)((Object)e));
            }
        }
        try {
            String mimeType;
            MagicMatch match = Magic.getMagicMatch((File)file, (boolean)true, (boolean)false);
            if (match.getSubMatches().isEmpty()) {
                mimeType = match.getMimeType();
            } else {
                Collection possibilities = match.getSubMatches();
                Iterator iter = possibilities.iterator();
                MagicMatch m = (MagicMatch)iter.next();
                mimeType = m.getMimeType();
                possibilities.clear();
                match.setSubMatches(possibilities);
            }
            if ("text/plain".equals(mimeType)) {
                byte[] bytes = new byte[16];
                int n = 0;
                try (FileInputStream is = new FileInputStream(file);){
                    n = is.read(bytes);
                }
                for (int i = 0; i < n; ++i) {
                    if (bytes[i] != 0) continue;
                    mimeType = "application/octet-stream";
                    break;
                }
            }
            return mimeType;
        }
        catch (MagicMatchNotFoundException e) {
            if (file.getAbsolutePath() != null) {
                return this.getMimetypeFromFilename(file.getAbsolutePath());
            }
            throw new MimetypeNotFoundException(e.getMessage(), e);
        }
        catch (IOException | MagicException | MagicParseException e) {
            throw new MimetypeDetectionException(e.getMessage(), e);
        }
    }

    @Override
    public String getMimetypeFromExtension(String extension) throws MimetypeNotFoundException {
        String lowerCaseExtension = extension.toLowerCase();
        ExtensionDescriptor extensionDescriptor = this.extensionRegistry.get(lowerCaseExtension);
        if (extensionDescriptor == null) {
            MimetypeEntry mimetype = this.mimetypeByExtensionRegistry.get(lowerCaseExtension);
            if (mimetype == null) {
                throw new MimetypeNotFoundException("no registered mimetype has extension: " + lowerCaseExtension);
            }
            return mimetype.getNormalized();
        }
        if (extensionDescriptor.isAmbiguous()) {
            throw new MimetypeNotFoundException(String.format("mimetype for %s is ambiguous, binary sniffing needed", lowerCaseExtension));
        }
        return extensionDescriptor.getMimetype();
    }

    @Override
    public String getMimetypeFromFilename(String filename) throws MimetypeNotFoundException {
        if (filename == null) {
            throw new MimetypeNotFoundException("filename is null");
        }
        String extension = FilenameUtils.getExtension((String)filename);
        if (StringUtils.isBlank((String)extension)) {
            throw new MimetypeNotFoundException(filename + "has no extension");
        }
        return this.getMimetypeFromExtension(extension);
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getMimetypeFromBlob(Blob blob) throws MimetypeNotFoundException, MimetypeDetectionException {
        try {
            File file = Framework.createTempFile((String)"NXMimetypeBean", (String)".bin");
            try {
                try (InputStream is = blob.getStream();){
                    FileUtils.copyInputStreamToFile((InputStream)is, (File)file);
                    String string = this.getMimetypeFromFile(file);
                    return string;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                file.delete();
            }
        }
        catch (IOException e) {
            throw new MimetypeDetectionException(e.getMessage(), e);
        }
    }

    @Override
    public MimetypeEntry getMimetypeEntryByMimeType(String mimetype) {
        MimetypeEntry mtype = this.mimetypeByNormalisedRegistry.get("application/octet-stream");
        if (mimetype != null) {
            for (String key : this.mimetypeByNormalisedRegistry.keySet()) {
                MimetypeEntry entry = this.mimetypeByNormalisedRegistry.get(key);
                if (!mimetype.equals(entry.getNormalized()) && !entry.getMimetypes().contains(mimetype)) continue;
                mtype = entry;
                break;
            }
        }
        return mtype;
    }

    @Override
    public String getMimetypeFromBlobWithDefault(Blob blob, String defaultMimetype) throws MimetypeDetectionException {
        try {
            return this.getMimetypeFromBlob(blob);
        }
        catch (MimetypeNotFoundException e) {
            return defaultMimetype;
        }
    }

    @Override
    public String getMimetypeFromFilenameAndBlobWithDefault(String filename, Blob blob, String defaultMimetype) throws MimetypeDetectionException {
        try {
            return this.getMimetypeFromFilename(filename);
        }
        catch (MimetypeNotFoundException e) {
            return this.getMimetypeFromBlobWithDefault(blob, defaultMimetype);
        }
    }

    @Override
    public String getMimetypeFromFilenameWithBlobMimetypeFallback(String filename, Blob blob, String defaultMimetype) throws MimetypeDetectionException {
        try {
            return this.getMimetypeFromFilename(filename);
        }
        catch (MimetypeNotFoundException e) {
            String mimeTypeName = blob.getMimeType();
            if (this.isMimetypeEntry(mimeTypeName)) {
                return mimeTypeName;
            }
            return this.getMimetypeFromBlobWithDefault(blob, defaultMimetype);
        }
    }

    @Override
    public Blob updateMimetype(Blob blob, String filename, Boolean withBlobMimetypeFallback) throws MimetypeDetectionException {
        if (filename == null) {
            filename = blob.getFilename();
        } else if (blob.getFilename() == null) {
            blob.setFilename(filename);
        }
        if (withBlobMimetypeFallback.booleanValue()) {
            blob.setMimeType(this.getMimetypeFromFilenameWithBlobMimetypeFallback(filename, blob, "application/octet-stream"));
        } else {
            blob.setMimeType(this.getMimetypeFromFilenameAndBlobWithDefault(filename, blob, "application/octet-stream"));
        }
        return blob;
    }

    @Override
    public Blob updateMimetype(Blob blob, String filename) throws MimetypeDetectionException {
        return this.updateMimetype(blob, filename, false);
    }

    @Override
    public Blob updateMimetype(Blob blob) throws MimetypeDetectionException {
        return this.updateMimetype(blob, null);
    }
}

