/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.codehaus.jackson.JsonNode;

public class InputStreamWithJsonNode
extends InputStream {
    private JsonNode jn;
    private InputStream real = null;

    public InputStreamWithJsonNode(JsonNode jn) {
        this.jn = jn;
    }

    public JsonNode getJsonNode() {
        return this.jn;
    }

    public InputStream getRealInputStream() {
        if (this.real == null) {
            this.real = new ByteArrayInputStream(this.jn.toString().getBytes());
        }
        return this.real;
    }

    @Override
    public int read() throws IOException {
        return this.getRealInputStream().read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.getRealInputStream().read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.getRealInputStream().read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.getRealInputStream().skip(n);
    }

    public String toString() {
        return this.getRealInputStream().toString();
    }

    @Override
    public int available() throws IOException {
        return this.getRealInputStream().available();
    }

    @Override
    public void close() throws IOException {
        if (this.real != null) {
            this.getRealInputStream().close();
        }
    }

    @Override
    public void mark(int readlimit) {
        this.getRealInputStream().mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        if (this.real != null) {
            this.getRealInputStream().reset();
        }
    }

    @Override
    public boolean markSupported() {
        return this.getRealInputStream().markSupported();
    }
}

