/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.enrichers;

import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.security.PermissionProvider;
import org.nuxeo.ecm.core.api.security.UserVisiblePermission;
import org.nuxeo.ecm.core.io.marshallers.json.enrichers.AbstractJsonEnricher;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.runtime.api.Framework;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class BasePermissionsJsonEnricher
extends AbstractJsonEnricher<DocumentModel> {
    public static final String NAME = "permissions";
    private final List<String> availablePermissions = Arrays.asList("Read", "Write", "Everything", "AddChildren", "ReadChildren", "RemoveChildren");

    public BasePermissionsJsonEnricher() {
        super(NAME);
    }

    @Override
    public void write(JsonGenerator jg, DocumentModel document) throws IOException {
        jg.writeArrayFieldStart(NAME);
        try (RenderingContext.SessionWrapper wrapper = this.ctx.getSession(document);){
            for (String permission : this.getPermissionsInSession(document, wrapper.getSession())) {
                jg.writeString(permission);
            }
        }
        jg.writeEndArray();
    }

    private Collection<String> getPermissionsInSession(DocumentModel doc, CoreSession session) {
        Principal principal = session.getPrincipal();
        PermissionProvider permissionProvider = (PermissionProvider)Framework.getService(PermissionProvider.class);
        Set permissions = permissionProvider.getUserVisiblePermissionDescriptors(doc.getType()).stream().map(UserVisiblePermission::getId).collect(Collectors.toSet());
        permissions.addAll(this.availablePermissions);
        return session.filterGrantedPermissions(principal, doc.getRef(), permissions);
    }
}

