/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.invite;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.user.invite.InvitationUserFactory;
import org.nuxeo.ecm.user.invite.UserRegistrationConfiguration;
import org.nuxeo.ecm.user.invite.UserRegistrationException;
import org.nuxeo.runtime.api.Framework;

public class DefaultInvitationUserFactory
implements InvitationUserFactory {
    private static final Log log = LogFactory.getLog(DefaultInvitationUserFactory.class);
    public static final String PASSWORD_KEY = "invitationPassword";

    @Override
    public void doPostUserCreation(CoreSession session, DocumentModel registrationDoc, NuxeoPrincipal user) throws UserRegistrationException {
    }

    @Override
    public NuxeoPrincipal doCreateUser(CoreSession session, DocumentModel registrationDoc, UserRegistrationConfiguration configuration) throws UserRegistrationException {
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        String email = (String)((Object)registrationDoc.getPropertyValue(configuration.getUserInfoEmailField()));
        if (email == null) {
            throw new UserRegistrationException("Email address must be specififed");
        }
        String login = (String)((Object)registrationDoc.getPropertyValue(configuration.getUserInfoUsernameField()));
        NuxeoPrincipal user = userManager.getPrincipal(login);
        if (user == null) {
            DocumentModel newUserDoc = userManager.getBareUserModel();
            newUserDoc.setPropertyValue("username", (Serializable)((Object)login));
            newUserDoc.setPropertyValue("password", registrationDoc.getContextData(PASSWORD_KEY));
            newUserDoc.setPropertyValue("firstName", registrationDoc.getPropertyValue(configuration.getUserInfoFirstnameField()));
            newUserDoc.setPropertyValue("lastName", registrationDoc.getPropertyValue(configuration.getUserInfoLastnameField()));
            newUserDoc.setPropertyValue("email", registrationDoc.getPropertyValue(configuration.getUserInfoEmailField()));
            newUserDoc.setPropertyValue("company", registrationDoc.getPropertyValue(configuration.getUserInfoCompanyField()));
            newUserDoc.setPropertyValue("groups", registrationDoc.getPropertyValue(configuration.getUserInfoGroupsField()));
            newUserDoc.setPropertyValue("tenantId", registrationDoc.getPropertyValue(configuration.getUserInfoTenantIdField()));
            userManager.createUser(newUserDoc);
            user = userManager.getPrincipal(login);
            log.info((Object)("New user created:" + user.getName()));
        } else if (!email.equals(((NuxeoPrincipalImpl)user).getEmail())) {
            throw new UserRegistrationException("This login is not available");
        }
        return user;
    }
}

