/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.commandline.executor.service.executors;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.ExceptionUtils;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.ExecResult;
import org.nuxeo.ecm.platform.commandline.executor.service.CommandLineDescriptor;
import org.nuxeo.ecm.platform.commandline.executor.service.EnvironmentDescriptor;
import org.nuxeo.ecm.platform.commandline.executor.service.executors.Executor;

public class ShellExecutor
implements Executor {
    private static final Log log = LogFactory.getLog(ShellExecutor.class);
    protected static final AtomicInteger PIPE_COUNT = new AtomicInteger();
    protected static final Pattern COMMAND_SPLIT = Pattern.compile("\"([^\"]*)\"|'([^']*)'|[^\\s]+");

    @Override
    @Deprecated
    public ExecResult exec(CommandLineDescriptor cmdDesc, CmdParameters params) {
        return this.exec(cmdDesc, params, new EnvironmentDescriptor());
    }

    @Override
    public ExecResult exec(CommandLineDescriptor cmdDesc, CmdParameters params, EnvironmentDescriptor env) {
        String commandLine = cmdDesc.getCommand() + " " + String.join((CharSequence)" ", cmdDesc.getParametersString());
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Running system command: " + commandLine));
            }
            long t0 = System.currentTimeMillis();
            ExecResult res = this.exec1(cmdDesc, params, env);
            long t1 = System.currentTimeMillis();
            return new ExecResult(commandLine, res.getOutput(), t1 - t0, res.getReturnCode());
        }
        catch (IOException e) {
            return new ExecResult(commandLine, e);
        }
    }

    protected ExecResult exec1(CommandLineDescriptor cmdDesc, CmdParameters params, EnvironmentDescriptor env) throws IOException {
        String line;
        ArrayList<String> list = new ArrayList<String>();
        list.add(cmdDesc.getCommand());
        Matcher m = COMMAND_SPLIT.matcher(cmdDesc.getParametersString());
        while (m.find()) {
            String word = m.group(1) != null ? m.group(1) : (m.group(2) != null ? m.group(2) : m.group());
            List<String> words = ShellExecutor.replaceParams(word, params);
            list.addAll(words);
        }
        LinkedList<Process> processes = new LinkedList<Process>();
        LinkedList<Thread> pipes = new LinkedList<Thread>();
        LinkedList<String> command = new LinkedList<String>();
        Process process = null;
        Iterator it = list.iterator();
        while (it.hasNext()) {
            boolean build;
            String word = (String)it.next();
            if (word.equals("|")) {
                build = true;
            } else {
                if (command.isEmpty() && SystemUtils.IS_OS_WINDOWS) {
                    command.add(ShellExecutor.getCommandAbsolutePath(word));
                } else {
                    command.add(word);
                }
                boolean bl = build = !it.hasNext();
            }
            if (!build) continue;
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            command = new LinkedList();
            processBuilder.directory(new File(env.getWorkingDirectory()));
            processBuilder.environment().putAll(env.getParameters());
            processBuilder.redirectErrorStream(true);
            Process newProcess = processBuilder.start();
            processes.add(newProcess);
            if (process == null) {
                IOUtils.closeQuietly((OutputStream)newProcess.getOutputStream());
            } else {
                Thread pipe = ShellExecutor.pipe(process.getInputStream(), newProcess.getOutputStream());
                pipes.add(pipe);
            }
            process = newProcess;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        ArrayList<String> output = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            output.add(line);
        }
        reader.close();
        int returnCode = 0;
        for (Process p : processes) {
            try {
                int exitCode = p.waitFor();
                if (returnCode != 0) continue;
                returnCode = exitCode;
            }
            catch (InterruptedException e) {
                ExceptionUtils.checkInterrupt((Exception)e);
            }
        }
        for (Thread t : pipes) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                ExceptionUtils.checkInterrupt((Exception)e);
            }
        }
        return new ExecResult(null, output, 0L, returnCode);
    }

    public static Thread pipe(final InputStream in, final OutputStream out) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    out.flush();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)in);
                    IOUtils.closeQuietly((OutputStream)out);
                }
            }
        };
        Thread thread = new Thread(run, "Nuxeo-pipe-" + PIPE_COUNT.incrementAndGet());
        thread.setDaemon(true);
        thread.start();
        return thread;
    }

    public static List<String> replaceParams(String word, CmdParameters params) {
        for (Map.Entry<String, CmdParameters.ParameterValue> es : params.getParameters().entrySet()) {
            String name = es.getKey();
            CmdParameters.ParameterValue paramVal = es.getValue();
            String param = "#{" + name + "}";
            if (paramVal.isMulti()) {
                if (!word.equals(param)) continue;
                return paramVal.getValues();
            }
            if (!word.contains(param)) continue;
            word = word.replace(param, paramVal.getValue());
        }
        return Collections.singletonList(word);
    }

    public static String getCommandAbsolutePath(String command) {
        if (Paths.get(command, new String[0]).isAbsolute()) {
            return command;
        }
        List<String> extensions = Arrays.asList("", ".exe");
        String[] systemPaths = System.getenv("PATH").split(File.pathSeparator);
        for (String ext : extensions) {
            for (String sp : systemPaths) {
                try {
                    Path path = Paths.get(sp.trim(), new String[0]);
                    if (!Files.exists(path.resolve(command + ext), new LinkOption[0])) continue;
                    return path.resolve(command + ext).toString();
                }
                catch (InvalidPathException e) {
                    log.warn((Object)("PATH environment variable contains an invalid path : " + e.getMessage()));
                }
            }
        }
        return command;
    }
}

