/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.cache.Cache;
import org.nuxeo.ecm.core.cache.CacheService;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.EntrySource;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.metrics.MetricsService;

public class DirectoryCache {
    private static final Serializable CACHE_MISS = Boolean.FALSE;
    protected final String name;
    protected Cache entryCache;
    protected String entryCacheName = null;
    protected Cache entryCacheWithoutReferences;
    protected String entryCacheWithoutReferencesName = null;
    protected boolean negativeCaching;
    protected final MetricRegistry metrics = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    protected final Counter hitsCounter;
    protected final Counter negativeHitsCounter;
    protected final Counter missesCounter;
    protected final Counter invalidationsCounter;
    protected final Counter sizeCounter;
    private static final Log log = LogFactory.getLog(DirectoryCache.class);

    protected DirectoryCache(String name) {
        this.name = name;
        this.hitsCounter = this.metrics.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"directories", name, "cache", "hits"}));
        this.negativeHitsCounter = this.metrics.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"directories", name, "cache", "neghits"}));
        this.missesCounter = this.metrics.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"directories", name, "cache", "misses"}));
        this.invalidationsCounter = this.metrics.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"directories", name, "cache", "invalidations"}));
        this.sizeCounter = this.metrics.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"directories", name, "cache", "size"}));
    }

    protected boolean isCacheEnabled() {
        return this.entryCacheName != null && this.entryCacheWithoutReferencesName != null;
    }

    public DocumentModel getEntry(String entryId, EntrySource source) throws DirectoryException {
        return this.getEntry(entryId, source, true);
    }

    public DocumentModel getEntry(String entryId, EntrySource source, boolean fetchReferences) throws DirectoryException {
        if (!this.isCacheEnabled()) {
            return source.getEntryFromSource(entryId, fetchReferences);
        }
        if (this.isCacheEnabled() && (this.getEntryCache() == null || this.getEntryCacheWithoutReferences() == null)) {
            if (log.isDebugEnabled()) {
                if (this.getEntryCache() == null) {
                    log.debug((Object)String.format("The cache '%s' is undefined for directory '%s', it will be created with the default cache configuration", this.entryCacheName, this.name));
                }
                if (this.getEntryCacheWithoutReferences() == null) {
                    log.debug((Object)String.format("The cache '%s' is undefined for directory '%s', it will be created with the default cache configuration", this.entryCacheWithoutReferencesName, this.name));
                }
            }
            return source.getEntryFromSource(entryId, fetchReferences);
        }
        Cache cache = fetchReferences ? this.getEntryCache() : this.getEntryCacheWithoutReferences();
        Serializable entry = cache.get(entryId);
        if (CACHE_MISS.equals(entry)) {
            this.negativeHitsCounter.inc();
            return null;
        }
        DocumentModel dm = (DocumentModel)entry;
        if (dm == null) {
            dm = source.getEntryFromSource(entryId, fetchReferences);
            if (dm != null) {
                try {
                    dm.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
                cache.put(entryId, (Serializable)dm);
                if (fetchReferences) {
                    this.sizeCounter.inc();
                }
            } else if (this.negativeCaching) {
                cache.put(entryId, CACHE_MISS);
            }
            this.missesCounter.inc();
        } else {
            this.hitsCounter.inc();
        }
        try {
            if (dm == null) {
                return null;
            }
            DocumentModel clone = dm.clone();
            if (BaseSession.isReadOnlyEntry(dm)) {
                BaseSession.setReadOnlyEntry(clone);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return dm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(List<String> entryIds) {
        if (this.isCacheEnabled()) {
            DirectoryCache directoryCache = this;
            synchronized (directoryCache) {
                for (String entryId : entryIds) {
                    this.sizeCounter.dec();
                    this.invalidationsCounter.inc();
                    Cache cache = this.getEntryCache();
                    if (cache != null) {
                        cache.invalidate(entryId);
                    }
                    if ((cache = this.getEntryCacheWithoutReferences()) == null) continue;
                    cache.invalidate(entryId);
                }
            }
        }
    }

    public void invalidate(String ... entryIds) {
        this.invalidate(Arrays.asList(entryIds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAll() {
        if (this.isCacheEnabled()) {
            DirectoryCache directoryCache = this;
            synchronized (directoryCache) {
                long count = this.sizeCounter.getCount();
                this.sizeCounter.dec(count);
                this.invalidationsCounter.inc(count);
                Cache cache = this.getEntryCache();
                if (cache != null) {
                    cache.invalidateAll();
                }
                if ((cache = this.getEntryCacheWithoutReferences()) != null) {
                    cache.invalidateAll();
                }
            }
        }
    }

    public void setEntryCacheName(String entryCacheName) {
        this.entryCacheName = entryCacheName;
    }

    public void setEntryCacheWithoutReferencesName(String entryCacheWithoutReferencesName) {
        this.entryCacheWithoutReferencesName = entryCacheWithoutReferencesName;
    }

    public void setNegativeCaching(Boolean negativeCaching) {
        this.negativeCaching = Boolean.TRUE.equals(negativeCaching);
    }

    public Cache getEntryCache() {
        if (this.entryCache == null) {
            this.entryCache = this.getCacheService().getCache(this.entryCacheName);
        }
        return this.entryCache;
    }

    public Cache getEntryCacheWithoutReferences() {
        if (this.entryCacheWithoutReferences == null) {
            this.entryCacheWithoutReferences = this.getCacheService().getCache(this.entryCacheWithoutReferencesName);
        }
        return this.entryCacheWithoutReferences;
    }

    protected CacheService getCacheService() {
        CacheService cacheService = (CacheService)Framework.getService(CacheService.class);
        if (cacheService == null) {
            throw new NuxeoException("Missing CacheService");
        }
        return cacheService;
    }
}

