/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.Hibernate;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.NvlFunction;
import org.hibernate.dialect.function.StandardSQLFunction;

public class PostgresPlusDialect
extends PostgreSQLDialect {
    public PostgresPlusDialect() {
        this.registerFunction("ltrim", new StandardSQLFunction("ltrim"));
        this.registerFunction("rtrim", new StandardSQLFunction("rtrim"));
        this.registerFunction("soundex", new StandardSQLFunction("soundex"));
        this.registerFunction("sysdate", new NoArgSQLFunction("sysdate", Hibernate.DATE, false));
        this.registerFunction("rowid", new NoArgSQLFunction("rowid", Hibernate.LONG, false));
        this.registerFunction("rownum", new NoArgSQLFunction("rownum", Hibernate.LONG, false));
        this.registerFunction("instr", new StandardSQLFunction("instr", Hibernate.INTEGER));
        this.registerFunction("lpad", new StandardSQLFunction("lpad", Hibernate.STRING));
        this.registerFunction("replace", new StandardSQLFunction("replace", Hibernate.STRING));
        this.registerFunction("rpad", new StandardSQLFunction("rpad", Hibernate.STRING));
        this.registerFunction("translate", new StandardSQLFunction("translate", Hibernate.STRING));
        this.registerFunction("substring", new StandardSQLFunction("substr", Hibernate.STRING));
        this.registerFunction("coalesce", new NvlFunction());
        this.registerFunction("atan2", new StandardSQLFunction("atan2", Hibernate.FLOAT));
        this.registerFunction("mod", new StandardSQLFunction("mod", Hibernate.INTEGER));
        this.registerFunction("nvl", new StandardSQLFunction("nvl"));
        this.registerFunction("nvl2", new StandardSQLFunction("nvl2"));
        this.registerFunction("power", new StandardSQLFunction("power", Hibernate.FLOAT));
        this.registerFunction("add_months", new StandardSQLFunction("add_months", Hibernate.DATE));
        this.registerFunction("months_between", new StandardSQLFunction("months_between", Hibernate.FLOAT));
        this.registerFunction("next_day", new StandardSQLFunction("next_day", Hibernate.DATE));
    }

    public String getCurrentTimestampSelectString() {
        return "select sysdate";
    }

    public String getCurrentTimestampSQLFunctionName() {
        return "sysdate";
    }

    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        statement.registerOutParameter(col, 2006);
        return ++col;
    }

    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        ps.execute();
        return (ResultSet)ps.getObject(1);
    }

    public String getSelectGUIDString() {
        return "select uuid_generate_v1";
    }
}

