/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.ByteBuffer;
import kafka.common.InvalidOffsetException;
import kafka.log.AbstractIndex;
import kafka.log.IndexEntry;
import kafka.log.IndexSearchType$;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.utils.CoreUtils$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001B\u0001\u0003\u0001\u001d\u00111b\u00144gg\u0016$\u0018J\u001c3fq*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0005\u0013)a!#D\u0001\u0003\u0013\tY!AA\u0007BEN$(/Y2u\u0013:$W\r\u001f\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0005\u0019>tw\r\u0005\u0002\u000e'%\u0011AC\u0004\u0002\u0004\u0013:$\b\u0002\u0003\f\u0001\u0005\u0003\u0005\u000b\u0011B\f\u0002\u000b}3\u0017\u000e\\3\u0011\u0005aiR\"A\r\u000b\u0005iY\u0012AA5p\u0015\u0005a\u0012\u0001\u00026bm\u0006L!AH\r\u0003\t\u0019KG.\u001a\u0005\nA\u0001\u0011\t\u0011)A\u0005\u0019\u0005\n!BY1tK>3gm]3u\u0013\t\u0001#\u0002C\u0005$\u0001\t\u0005\t\u0015!\u0003\u0013I\u0005aQ.\u0019=J]\u0012,\u0007pU5{K&\u00111E\u0003\u0005\nM\u0001\u0011\t\u0011)A\u0005O)\n\u0001b\u001e:ji\u0006\u0014G.\u001a\t\u0003\u001b!J!!\u000b\b\u0003\u000f\t{w\u000e\\3b]&\u0011aE\u0003\u0005\u0006Y\u0001!\t!L\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b9z\u0003'\r\u001a\u0011\u0005%\u0001\u0001\"\u0002\f,\u0001\u00049\u0002\"\u0002\u0011,\u0001\u0004a\u0001bB\u0012,!\u0003\u0005\rA\u0005\u0005\bM-\u0002\n\u00111\u0001(\u0011\u0015!\u0004\u0001\"\u00116\u0003%)g\u000e\u001e:z'&TX-F\u0001\u0013\u0011\u00199\u0004\u0001)Q\u0005\u0019\u0005Yq\f\\1ti>3gm]3u\u0011\u0015I\u0004\u0001\"\u0003;\u0003%a\u0017m\u001d;F]R\u0014\u00180F\u0001<!\tIA(\u0003\u0002>\u0005\tqqJ\u001a4tKR\u0004vn]5uS>t\u0007\"B \u0001\t\u0003\u0001\u0015A\u00037bgR|eMZ:fiV\tA\u0002C\u0003C\u0001\u0011\u00051)\u0001\u0004m_>\\W\u000f\u001d\u000b\u0003w\u0011CQ!R!A\u00021\tA\u0002^1sO\u0016$xJ\u001a4tKRDQa\u0012\u0001\u0005\u0002!\u000bQCZ3uG\",\u0006\u000f]3s\u0005>,h\u000eZ(gMN,G\u000fF\u0002J\u0019:\u00032!\u0004&<\u0013\tYeB\u0001\u0004PaRLwN\u001c\u0005\u0006\u001b\u001a\u0003\raO\u0001\fM\u0016$8\r[(gMN,G\u000fC\u0003P\r\u0002\u0007!#A\u0005gKR\u001c\u0007nU5{K\")\u0011\u000b\u0001C\u0005%\u0006q!/\u001a7bi&4Xm\u00144gg\u0016$Hc\u0001\nT7\")A\u000b\u0015a\u0001+\u00061!-\u001e4gKJ\u0004\"AV-\u000e\u0003]S!\u0001W\u000e\u0002\u00079Lw.\u0003\u0002[/\nQ!)\u001f;f\u0005V4g-\u001a:\t\u000bq\u0003\u0006\u0019\u0001\n\u0002\u00039DQA\u0018\u0001\u0005\n}\u000b\u0001\u0002\u001d5zg&\u001c\u0017\r\u001c\u000b\u0004%\u0001\f\u0007\"\u0002+^\u0001\u0004)\u0006\"\u0002/^\u0001\u0004\u0011\u0002\"B2\u0001\t\u0003\"\u0017A\u00039beN,WI\u001c;ssR\u0019Q\r[5\u0011\u0005%1\u0017BA4\u0003\u0005)Ie\u000eZ3y\u000b:$(/\u001f\u0005\u0006)\n\u0004\r!\u0016\u0005\u00069\n\u0004\rA\u0005\u0005\u0006W\u0002!\t\u0001\\\u0001\u0006K:$(/\u001f\u000b\u0003w5DQ\u0001\u00186A\u0002IAQa\u001c\u0001\u0005\u0002A\fa!\u00199qK:$GcA9umB\u0011QB]\u0005\u0003g:\u0011A!\u00168ji\")QO\u001ca\u0001\u0019\u00051qN\u001a4tKRDQa\u001e8A\u0002I\t\u0001\u0002]8tSRLwN\u001c\u0005\u0006s\u0002!\tE_\u0001\tiJ,hnY1uKR\t\u0011\u000fC\u0003}\u0001\u0011\u0005S0\u0001\u0006ueVt7-\u0019;f)>$\"!\u001d@\t\u000bU\\\b\u0019\u0001\u0007\t\u000f\u0005\u0005\u0001\u0001\"\u0003\u0002\u0004\u0005\tBO];oG\u0006$X\rV8F]R\u0014\u0018.Z:\u0015\u0007E\f)\u0001\u0003\u0004\u0002\b}\u0004\rAE\u0001\bK:$(/[3t\u0011\u0019\tY\u0001\u0001C!u\u0006Y1/\u00198jif\u001c\u0005.Z2l\u00111\ty\u0001\u0001I\u0001\u0004\u0003\u0005I\u0011B\u001b%\u0003I\u0019X\u000f]3sI5\f\u00070\u00138eKb\u001c\u0016N_3\t\u0019\u0005M\u0001\u0001%A\u0002\u0002\u0003%I\u0001Q\u0011\u0002!M,\b/\u001a:%E\u0006\u001cXm\u00144gg\u0016$x!CA\f\u0005\u0005\u0005\t\u0012AA\r\u0003-yeMZ:fi&sG-\u001a=\u0011\u0007%\tYB\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AA\u000f'\u0011\tY\"a\b\u0011\u00075\t\t#C\u0002\u0002$9\u0011a!\u00118z%\u00164\u0007b\u0002\u0017\u0002\u001c\u0011\u0005\u0011q\u0005\u000b\u0003\u00033A!\"a\u000b\u0002\u001cE\u0005I\u0011AA\u0017\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\u0006\u0016\u0004%\u0005E2FAA\u001a!\u0011\t)$a\u0010\u000e\u0005\u0005]\"\u0002BA\u001d\u0003w\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005ub\"\u0001\u0006b]:|G/\u0019;j_:LA!!\u0011\u00028\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\u0005\u0015\u00131DI\u0001\n\u0003\t9%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u0013R3aJA\u0019\u0001")
public class OffsetIndex
extends AbstractIndex<Object, Object> {
    public long kafka$log$OffsetIndex$$_lastOffset = this.kafka$log$OffsetIndex$$lastEntry().offset();

    public static boolean $lessinit$greater$default$4() {
        return OffsetIndex$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return OffsetIndex$.MODULE$.$lessinit$greater$default$3();
    }

    public /* synthetic */ int kafka$log$OffsetIndex$$super$maxIndexSize() {
        return super.maxIndexSize();
    }

    public /* synthetic */ long kafka$log$OffsetIndex$$super$baseOffset() {
        return super.baseOffset();
    }

    @Override
    public int entrySize() {
        return 8;
    }

    public OffsetPosition kafka$log$OffsetIndex$$lastEntry() {
        return (OffsetPosition)CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;

            public final OffsetPosition apply() {
                OffsetPosition offsetPosition;
                int n = this.$outer._entries();
                switch (n) {
                    default: {
                        offsetPosition = (OffsetPosition)this.$outer.parseEntry(this.$outer.mmap(), n - 1);
                        break;
                    }
                    case 0: {
                        offsetPosition = new OffsetPosition(this.$outer.kafka$log$OffsetIndex$$super$baseOffset(), 0);
                    }
                }
                return offsetPosition;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public long lastOffset() {
        return this.kafka$log$OffsetIndex$$_lastOffset;
    }

    public OffsetPosition lookup(long targetOffset) {
        return (OffsetPosition)this.maybeLock(this.lock(), new Serializable(this, targetOffset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final long targetOffset$1;

            public final OffsetPosition apply() {
                ByteBuffer idx = this.$outer.mmap().duplicate();
                int slot = this.$outer.largestLowerBoundSlotFor(idx, this.targetOffset$1, IndexSearchType$.MODULE$.KEY());
                return slot == -1 ? new OffsetPosition(this.$outer.kafka$log$OffsetIndex$$super$baseOffset(), 0) : (OffsetPosition)this.$outer.parseEntry(idx, slot);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.targetOffset$1 = targetOffset$1;
            }
        });
    }

    public Option<OffsetPosition> fetchUpperBoundOffset(OffsetPosition fetchOffset, int fetchSize) {
        return (Option)this.maybeLock(this.lock(), new Serializable(this, fetchOffset, fetchSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final OffsetPosition fetchOffset$1;
            private final int fetchSize$1;

            public final Option<OffsetPosition> apply() {
                ByteBuffer idx = this.$outer.mmap().duplicate();
                int slot = this.$outer.smallestUpperBoundSlotFor(idx, this.fetchOffset$1.position() + this.fetchSize$1, IndexSearchType$.MODULE$.VALUE());
                return slot == -1 ? None$.MODULE$ : new Some((Object)((OffsetPosition)this.$outer.parseEntry(idx, slot)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fetchOffset$1 = fetchOffset$1;
                this.fetchSize$1 = fetchSize$1;
            }
        });
    }

    public int kafka$log$OffsetIndex$$relativeOffset(ByteBuffer buffer, int n) {
        return buffer.getInt(n * this.entrySize());
    }

    public int kafka$log$OffsetIndex$$physical(ByteBuffer buffer, int n) {
        return buffer.getInt(n * this.entrySize() + 4);
    }

    @Override
    public IndexEntry parseEntry(ByteBuffer buffer, int n) {
        return new OffsetPosition(super.baseOffset() + (long)this.kafka$log$OffsetIndex$$relativeOffset(buffer, n), this.kafka$log$OffsetIndex$$physical(buffer, n));
    }

    public OffsetPosition entry(int n) {
        return (OffsetPosition)this.maybeLock(this.lock(), new Serializable(this, n){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final int n$1;

            public final OffsetPosition apply() {
                if (this.n$1 >= this.$outer._entries()) {
                    throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Attempt to fetch the %dth entry from an index of size %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.n$1), BoxesRunTime.boxToInteger((int)this.$outer._entries())})));
                }
                ByteBuffer idx = this.$outer.mmap().duplicate();
                return new OffsetPosition(this.$outer.kafka$log$OffsetIndex$$relativeOffset(idx, this.n$1), this.$outer.kafka$log$OffsetIndex$$physical(idx, this.n$1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.n$1 = n$1;
            }
        });
    }

    public void append(long offset2, int position) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, offset2, position){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            public final long offset$1;
            public final int position$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Predef$.MODULE$.require(!this.$outer.isFull(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$append$1 $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Attempt to append to a full index (size = ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer()._entries())).append((Object)").").toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                if (this.$outer._entries() == 0 || this.offset$1 > this.$outer.kafka$log$OffsetIndex$$_lastOffset) {
                    this.$outer.debug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$append$1 $outer;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Adding index entry %d => %d to %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.offset$1), BoxesRunTime.boxToInteger((int)this.$outer.position$1), this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().file().getName()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.$outer.mmap().putInt((int)(this.offset$1 - this.$outer.kafka$log$OffsetIndex$$super$baseOffset()));
                    this.$outer.mmap().putInt(this.position$1);
                    this.$outer._entries_$eq(this.$outer._entries() + 1);
                    this.$outer.kafka$log$OffsetIndex$$_lastOffset = this.offset$1;
                    Predef$.MODULE$.require(this.$outer._entries() * this.$outer.entrySize() == this.$outer.mmap().position(), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$append$1 $outer;

                        public final String apply() {
                            return new StringBuilder().append(this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().entries()).append((Object)" entries but file position in index is ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().mmap().position())).append((Object)".").toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    return;
                }
                throw new InvalidOffsetException(new StringOps(Predef$.MODULE$.augmentString("Attempt to append an offset (%d) to position %d no larger than the last offset appended (%d) to %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.offset$1), BoxesRunTime.boxToInteger((int)this.$outer.entries()), BoxesRunTime.boxToLong((long)this.$outer.kafka$log$OffsetIndex$$_lastOffset), this.$outer.file().getAbsolutePath()})));
            }

            public /* synthetic */ OffsetIndex kafka$log$OffsetIndex$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offset$1 = offset$1;
                this.position$1 = position$1;
            }
        });
    }

    @Override
    public void truncate() {
        this.kafka$log$OffsetIndex$$truncateToEntries(0);
    }

    @Override
    public void truncateTo(long offset2) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, offset2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final long offset$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ByteBuffer idx = this.$outer.mmap().duplicate();
                int slot = this.$outer.largestLowerBoundSlotFor(idx, this.offset$2, IndexSearchType$.MODULE$.KEY());
                int newEntries = slot < 0 ? 0 : ((long)this.$outer.kafka$log$OffsetIndex$$relativeOffset(idx, slot) == this.offset$2 - this.$outer.kafka$log$OffsetIndex$$super$baseOffset() ? slot : slot + 1);
                this.$outer.kafka$log$OffsetIndex$$truncateToEntries(newEntries);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offset$2 = offset$2;
            }
        });
    }

    public void kafka$log$OffsetIndex$$truncateToEntries(int entries) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, entries){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final int entries$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer._entries_$eq(this.entries$1);
                this.$outer.mmap().position(this.$outer._entries() * this.$outer.entrySize());
                this.$outer.kafka$log$OffsetIndex$$_lastOffset = this.$outer.kafka$log$OffsetIndex$$lastEntry().offset();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.entries$1 = entries$1;
            }
        });
    }

    @Override
    public void sanityCheck() {
        Predef$.MODULE$.require(this._entries() == 0 || this.kafka$log$OffsetIndex$$_lastOffset > super.baseOffset(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Corrupt index found, index file (", ") has non-zero size but the last offset "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.file().getAbsolutePath()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is ", " which is no larger than the base offset ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.kafka$log$OffsetIndex$$_lastOffset), BoxesRunTime.boxToLong((long)this.$outer.kafka$log$OffsetIndex$$super$baseOffset())}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        long len = this.file().length();
        Predef$.MODULE$.require(len % (long)this.entrySize() == 0L, (Function0)new Serializable(this, len){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final long len$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Index file ").append((Object)this.$outer.file().getAbsolutePath()).append((Object)" is corrupt, found ").append((Object)BoxesRunTime.boxToLong((long)this.len$1)).append((Object)" bytes which is not positive or not a multiple of 8.").toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.len$1 = len$1;
            }
        });
    }

    public OffsetIndex(File _file, long baseOffset, int maxIndexSize, boolean writable) {
        super(_file, baseOffset, maxIndexSize, writable);
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Loaded index file %s with maxEntries = %d, maxIndexSize = %d, entries = %d, lastOffset = %d, file position = %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)this.$outer.maxEntries()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$OffsetIndex$$super$maxIndexSize()), BoxesRunTime.boxToInteger((int)this.$outer._entries()), BoxesRunTime.boxToLong((long)this.$outer.kafka$log$OffsetIndex$$_lastOffset), BoxesRunTime.boxToInteger((int)this.$outer.mmap().position())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

