/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event;

import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.EventServiceAdmin;
import org.nuxeo.ecm.core.event.impl.EventListenerDescriptor;
import org.nuxeo.ecm.core.event.impl.EventServiceImpl;
import org.nuxeo.ecm.core.event.pipe.EventPipeDescriptor;
import org.nuxeo.ecm.core.event.pipe.dispatch.EventDispatcherDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class EventServiceComponent
extends DefaultComponent {
    public static final int APPLICATION_STARTED_ORDER = -500;
    public static final String EVENT_LISTENER_XP = "listener";
    public static final String EVENT_PIPE_XP = "pipe";
    public static final String EVENT_DISPATCHER_XP = "dispatcher";
    public static final long DEFAULT_SHUTDOWN_TIMEOUT = 5000L;
    protected EventServiceImpl service;

    public void activate(ComponentContext context) {
        this.service = new EventServiceImpl();
    }

    public void applicationStarted(ComponentContext context) {
        this.service.init();
    }

    public void deactivate(ComponentContext context) {
        if (this.service != null) {
            String s = Framework.getProperty((String)"org.nuxeo.ecm.core.event.shutdown.timeoutMillis");
            long timeout = s == null ? 5000L : Long.parseLong(s);
            try {
                this.service.shutdown(timeout);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            this.service = null;
        }
    }

    public int getApplicationStartedOrder() {
        return -500;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (EVENT_LISTENER_XP.equals(extensionPoint)) {
            EventListenerDescriptor descriptor = (EventListenerDescriptor)contribution;
            descriptor.setRuntimeContext(contributor.getRuntimeContext());
            try {
                this.service.addEventListener(descriptor);
            }
            catch (RuntimeException e) {
                String msg = "Failed to register event listener in component '" + contributor.getName() + "': error initializing event listener '" + descriptor.getName() + "' (" + e.toString() + ')';
                Framework.getRuntime().getMessageHandler().addError(msg);
            }
        } else if (EVENT_PIPE_XP.equals(extensionPoint)) {
            EventPipeDescriptor descriptor = (EventPipeDescriptor)contribution;
            this.service.addEventPipe(descriptor);
        } else if (EVENT_DISPATCHER_XP.equals(extensionPoint)) {
            EventDispatcherDescriptor descriptor = (EventDispatcherDescriptor)contribution;
            this.service.addEventDispatcher(descriptor);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (EVENT_LISTENER_XP.equals(extensionPoint)) {
            this.service.removeEventListener((EventListenerDescriptor)contribution);
        } else if (EVENT_PIPE_XP.equals(extensionPoint)) {
            EventPipeDescriptor descriptor = (EventPipeDescriptor)contribution;
            this.service.removeEventPipe(descriptor);
        } else if (EVENT_DISPATCHER_XP.equals(extensionPoint)) {
            EventDispatcherDescriptor descriptor = (EventDispatcherDescriptor)contribution;
            this.service.removeEventDispatcher(descriptor);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (EventService.class == adapter || EventProducer.class == adapter || EventServiceAdmin.class == adapter) {
            return (T)this.service;
        }
        return null;
    }
}

