/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.buffer.CircularFifoBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.work.WorkHolder;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.lib.stream.computation.AbstractComputation;
import org.nuxeo.lib.stream.computation.ComputationContext;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.runtime.metrics.MetricsService;

public class WorkComputation
extends AbstractComputation {
    private static final Log log = LogFactory.getLog(WorkComputation.class);
    protected static final int IDS_SIZE = 50;
    protected final CircularFifoBuffer workIds = new CircularFifoBuffer(50);
    protected final Timer workTimer;

    public WorkComputation(String name) {
        super(name, 1, 0);
        MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
        this.workTimer = registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"works", name, "total"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRecord(ComputationContext context, String inputStreamName, Record record) {
        Work work = WorkComputation.deserialize(record.data);
        try {
            if (this.workIds.contains((Object)work.getId())) {
                log.warn((Object)("Duplicate work id: " + work.getId() + " skipping"));
            } else {
                new WorkHolder(work).run();
                this.workIds.add((Object)work.getId());
            }
        }
        catch (Exception e) {
            log.warn((Object)String.format("Work id: %s title: %s, raise an exception, work is marked as completed", work.getId(), work.getTitle()), (Throwable)e);
        }
        finally {
            work.cleanUp(true, null);
            this.workTimer.update(work.getCompletionTime() - work.getStartTime(), TimeUnit.MILLISECONDS);
            context.askForCheckpoint();
        }
    }

    public static Work deserialize(byte[] data) {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(bis);
            Work work = (Work)in.readObject();
            return work;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static byte[] serialize(Work work) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(work);
            out.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            System.out.println("Error " + e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException iOException) {}
        }
    }
}

