/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.kafka;

import java.util.Properties;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;

@XObject(value="kafkaConfig")
public class KafkaConfigDescriptor {
    @XNode(value="@name")
    public String name;
    @XNode(value="@zkServers")
    public String zkServers;
    @XNode(value="@topicPrefix")
    public String topicPrefix;
    @XNode(value="@randomPrefix")
    public Boolean randomPrefix = Boolean.FALSE;
    @XNode(value="producer")
    protected ProducerProperties producerProperties;
    @XNode(value="consumer")
    protected ConsumerProperties consumerProperties;

    public Properties getProducerProperties() {
        if (this.producerProperties == null) {
            return new Properties();
        }
        return this.producerProperties.properties;
    }

    public Properties getConsumerProperties() {
        if (this.consumerProperties == null) {
            return new Properties();
        }
        return this.consumerProperties.properties;
    }

    public String getTopicPrefix() {
        String ret;
        String string = ret = this.topicPrefix == null ? "" : this.topicPrefix;
        if (this.randomPrefix.booleanValue()) {
            ret = ret + System.currentTimeMillis() + "-";
        }
        return ret;
    }

    @XObject(value="consumer")
    public static class ConsumerProperties {
        @XNodeMap(value="property", key="@name", type=Properties.class, componentType=String.class)
        protected Properties properties = new Properties();
    }

    @XObject(value="producer")
    public static class ProducerProperties {
        @XNodeMap(value="property", key="@name", type=Properties.class, componentType=String.class)
        protected Properties properties = new Properties();
    }
}

