/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.stream;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;

@XObject(value="logConfig")
public class LogConfigDescriptor {
    @XNode(value="@name")
    public String name;
    @XNode(value="@type")
    public String type;
    @XNodeMap(value="option", key="@name", type=HashMap.class, componentType=String.class)
    public Map<String, String> options = new HashMap<String, String>();
    @XNodeList(value="log", type=ArrayList.class, componentType=StreamDescriptor.class)
    public List<StreamDescriptor> logs = new ArrayList<StreamDescriptor>(0);

    public String getName() {
        return this.name;
    }

    public boolean isKafkaLog() {
        return "kafka".equalsIgnoreCase(this.type);
    }

    public String getOption(String key, String defaultValue) {
        return this.options.getOrDefault(key, defaultValue);
    }

    public Map<String, Integer> getLogsToCreate() {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        this.logs.forEach(d -> ret.put(d.name, d.size));
        return ret;
    }

    @XObject(value="log")
    public static class StreamDescriptor {
        public static final Integer DEFAULT_PARTITIONS = 4;
        @XNode(value="@name")
        public String name;
        @XNode(value="@size")
        public Integer size = DEFAULT_PARTITIONS;
    }
}

