/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.stream;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.lib.stream.computation.Settings;
import org.nuxeo.lib.stream.computation.Topology;
import org.nuxeo.runtime.stream.StreamProcessorTopology;

@XObject(value="streamProcessor")
public class StreamProcessorDescriptor {
    public static final Integer DEFAULT_CONCURRENCY = 4;
    @XNode(value="@name")
    public String name;
    @XNode(value="@logConfig")
    public String config;
    @XNode(value="@class")
    public Class<? extends StreamProcessorTopology> klass;
    @XNode(value="@defaultConcurrency")
    public Integer defaultConcurrency = DEFAULT_CONCURRENCY;
    @XNode(value="@defaultPartitions")
    public Integer defaultPartitions = DEFAULT_CONCURRENCY;
    @XNodeMap(value="option", key="@name", type=HashMap.class, componentType=String.class)
    public Map<String, String> options = new HashMap<String, String>();
    @XNodeList(value="computation", type=ArrayList.class, componentType=ComputationDescriptor.class)
    public List<ComputationDescriptor> computations = new ArrayList<ComputationDescriptor>(0);
    @XNodeList(value="stream", type=ArrayList.class, componentType=StreamDescriptor.class)
    public List<StreamDescriptor> streams = new ArrayList<StreamDescriptor>(0);

    public String getName() {
        return this.name;
    }

    public Settings getSettings() {
        Settings settings = new Settings(this.defaultConcurrency.intValue(), this.defaultPartitions.intValue());
        this.computations.forEach(comp -> settings.setConcurrency(comp.name, comp.concurrency.intValue()));
        this.streams.forEach(stream -> settings.setPartitions(stream.name, stream.partitions.intValue()));
        return settings;
    }

    public Topology getTopology() {
        try {
            return this.klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).getTopology(this.options);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Can not create topology for processor: " + this.name, e);
        }
    }

    @XObject(value="stream")
    public static class StreamDescriptor {
        @XNode(value="@name")
        public String name;
        @XNode(value="@partitions")
        public Integer partitions = DEFAULT_CONCURRENCY;
    }

    @XObject(value="computation")
    public static class ComputationDescriptor {
        @XNode(value="@name")
        public String name;
        @XNode(value="@concurrency")
        public Integer concurrency = DEFAULT_CONCURRENCY;
    }
}

