/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.statuses;

import java.util.List;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.management.api.Probe;
import org.nuxeo.ecm.core.management.api.ProbeStatus;
import org.nuxeo.ecm.core.repository.RepositoryService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class RepositoryStatusProbe
implements Probe {
    @Override
    public ProbeStatus run() {
        ProbeStatus status = (ProbeStatus)TransactionHelper.runInTransaction(() -> {
            List<String> repositories = this.getRepositoryName();
            boolean success = !repositories.isEmpty();
            for (String repository : repositories) {
                success = success && (Boolean)CoreInstance.doPrivileged((String)repository, session -> session.exists(session.getRootDocument().getRef())) != false;
            }
            if (success) {
                return ProbeStatus.newSuccess("Repository started");
            }
            return ProbeStatus.newFailure("Repository not started corectly");
        });
        return status;
    }

    protected List<String> getRepositoryName() {
        return ((RepositoryService)Framework.getService(RepositoryService.class)).getRepositoryNames();
    }
}

