/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import com.google.common.base.Predicate;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import javax.faces.component.UIComponent;

public final class ComponentIterators {
    private ComponentIterators() {
    }

    public static Iterator<UIComponent> parents(final UIComponent component) {
        if (component == null) {
            return ImmutableSet.of().iterator();
        }
        return new AbstractIterator<UIComponent>(){
            private UIComponent currentComponent;
            {
                this.currentComponent = component;
            }

            protected UIComponent computeNext() {
                this.currentComponent = this.currentComponent.getParent();
                if (this.currentComponent == null) {
                    this.endOfData();
                }
                return this.currentComponent;
            }
        };
    }

    public static Iterator<UIComponent> parentsAndSelf(UIComponent component) {
        if (component == null) {
            return ImmutableSet.of().iterator();
        }
        return Iterators.concat((Iterator)Iterators.singletonIterator((Object)component), ComponentIterators.parents(component));
    }

    public static UIComponent getParent(UIComponent component, Predicate<UIComponent> predicat) {
        if (component == null || predicat == null) {
            return null;
        }
        for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!predicat.apply((Object)parent)) continue;
            return parent;
        }
        return null;
    }

    public static <T extends UIComponent> T getParent(UIComponent component, Class<T> parentClass) {
        if (component == null || parentClass == null) {
            return null;
        }
        for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!parentClass.isInstance(parent)) continue;
            return (T)parent;
        }
        return null;
    }
}

